<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_order', function (Blueprint $table) {
            $table->id();
            $table->integer('status')->nullable()->comment('new, paid, canceled');
            $table->integer('user_id')->nullable();
            $table->integer('company_id')->nullable();
            $table->integer('order_id')->nullable();
            $table->json('products')->nullable()->comment('[{id, name, price, amount, options}, ...]');
            $table->decimal('subtotal', 10, 2)->nullable();
            $table->decimal('tax', 10, 2)->default(0);
            $table->decimal('tips', 10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->integer('discount_from_user')->nullable();
            $table->decimal('total', 10, 2)->nullable();
            $table->integer("tip_percent")->default(0);
            $table->string("payment_method")->default("gift_card");
            $table->double('paid_amount')->default(0);
            $table->tinyInteger("is_customer_pickedup")->nullable()->comment("1:picked up else No (If table type is pickup)	");
            $table->timestamp('canceled_at')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_order');
    }
};
