<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('used_discounts', function (Blueprint $table) {
            $table->id();
            $table->integer('user_order_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('user_discount_id')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->integer('company_id')->default(1);
            $table->dateTime('used_at')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('used_discounts');
    }
};
