<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('promo_post', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('promo_id')->nullable();
            $table->unsignedBigInteger('promo_type_id')->nullable();
            $table->string('title')->nullable();
            $table->text('text')->nullable();
            $table->string('files')->nullable();
            $table->timestamps();

            $table->foreign('promo_id')
            ->references('id')
            ->on('promos')
            ->onUpdate('cascade')
            ->onDelete('cascade');

            $table->foreign('promo_type_id')
            ->references('id')
            ->on('promo_types')
            ->onUpdate('cascade')
            ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('promo_post');
    }
};
