<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId("company_id")->constrained()->onDelete("cascade");
            $table->integer('category_id')->nullable();
            $table->integer('menu_id')->nullable();
            $table->integer('menu_type_id')->nullable();
            $table->string("name");
            $table->string('description')->nullable();
            $table->string("product_image")->nullable();
            $table->decimal('price', 15, 2);
            $table->string("option_type", 20)->nullable();
            // $table->json('prices')->nullable();
            // $table->json('options')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
