<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('claims', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->float('hypothetical_balance')->nullable();
            $table->float('actual_balance')->nullable();
            $table->float('amount_claim')->nullable();
            $table->integer('user_claim_allowed')->nullable();
            $table->integer('claim_setting_enable')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('company_id')->nullable();

            $table->integer('expire_days')->default('1');
            $table->dateTime('expire', $precision = 0)->nullable();
            $table->integer('claim_per_day')->nullable();
            $table->float('first_user')->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('claims');
    }
};
