<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('regular_gift_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->decimal('gift_amount_1', 10, 2)->nullable();
            $table->decimal('gift_amount_2', 10, 2)->nullable();
            $table->decimal('gift_amount_3', 10, 2)->nullable();
            $table->decimal('discount', 10, 2)->nullable();
            $table->dateTime('expire_at')->nullable();
            $table->integer('company_id')->nullable();
            $table->tinyInteger('for_some_one')->default(false);
            $table->tinyInteger('discount_type')->nullable();
            $table->decimal('discount_someone', 10, 2)->nullable();
            $table->decimal('discount_limit_value', 10, 2)->nullable();
            $table->decimal('discount_limit', 10, 2)->default(0);
            $table->tinyInteger('is_regular_free')->default(0);
            $table->decimal('receipent_will_get', 10, 2)->default(0);
            $table->decimal('buyer_will_get_first_time', 10, 2)->default(0);
            $table->decimal('buyer_will_get_second_time', 10, 2)->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('regular_gift_settings');
    }
};
