<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('global_discounts', function (Blueprint $table) {
            $table->id();
            $table->double("credit_amount",8,2);
            $table->integer("regular_discount");
            $table->integer("deal_discount");
            $table->double("regular_price", 8, 2);
            $table->double("deal_price", 8, 2);
            $table->integer("show_discount");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('global_discounts');
    }
};
