<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('egifts', function (Blueprint $table) {
            $table->id();
            $table->foreignId("user_id")->constrained()->onDelete("cascade")->comment('recipient id');
            $table->foreignId("customer_stripe_info_id");
            $table->unsignedBigInteger("sender_id");
            $table->foreign('sender_id')->references('id')->on('users')->onDelete('cascade');
            $table->double("total_credit", 8, 2);
            $table->double("gift_amount", 8, 2);
            $table->double("extra_saving", 8, 2);
            $table->double("activation_fee", 8, 2);
            $table->double("total_pay", 8, 2);
            $table->string('message')->nullable();
            // $table->string("activation_code", 20);
            // $table->boolean("is_active")->default(false);
            $table->boolean("is_confirmed")->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('egifts');
    }
};
