<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_product_sizes', function (Blueprint $table) {
            $table->id();
            $table->integer('size_id');
            $table->integer('product_id');
            $table->integer('order_id')->nullable();
            $table->integer('user_order_id')->nullable();
            $table->integer('size_qty');
            $table->double('size_unit_price');
            $table->double('size_total_price');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_product_sizes');
    }
};
