<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Company') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                
                <div>
                    <form action="{{ route('company.settings.update') }}" method="POST">
                        @csrf
                        {{-- Payout Days --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="type_id">
                                Company Type - {{ucfirst($company->type?->name)}}
                            </label>
                            <select name="type_id"
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                <option value="">Select Company Type</option>
                                @foreach ($company_types as $company_type)
                                    <option @if($company_type->id == $company->type?->id) selected @endif value="{{$company_type->id}}">
                                        {{$company_type->name}}
                                    </option>
                                @endforeach
                            </select>
                            @error('type_id')
                                <span class="text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        {{-- company_name --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="company_name">
                                Company Name
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="company_name" type="text" name="company_name"
                                value="{{ $company->name }}">
                                @error('company_name')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                        {{-- address_line_1 --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="address_line_1">
                                Address Line 1
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="address_line_1" type="text" name="address_line_1" autofocus="autofocus"
                                value="{{ $company->address_line_1 }}">
                                @error('address_line_1')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                        {{-- address_line_2 --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="address_line_2">
                                Address Line 2
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="address_line_2" type="text" name="address_line_2" autofocus="autofocus"
                                value="{{ $company->address_line_1 }}">
                                @error('address_line_2')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                        {{-- reservation_fee --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="reservation_fee">
                                Reservation Fee
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="reservation_fee" type="number" name="reservation_fee" autofocus="autofocus"
                                value="{{ $company->reservation_fee }}">
                                @error('reservation_fee')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                         {{-- reservation_before --}}
                         <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="reservation_before">
                                Reservation Before
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="reservation_before" type="number" name="reservation_before" autofocus="autofocus"
                                value="{{ $company->reservation_before }}">
                                @error('reservation_before')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                        {{-- cancelation_fee --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="cancelation_fee">
                                Cancelation Fee
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="cancelation_fee" type="number" name="cancelation_fee" autofocus="autofocus"
                                value="{{ $company->cancelation_fee }}">
                                @error('cancelation_fee')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                        {{-- postal_code --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="postal_code">
                                Postal Code
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="postal_code" type="number" name="postal_code" autofocus="autofocus"
                                value="{{ $company->postal_code }}">
                                @error('postal_code')
                                    <small class="text-red-500">{{ $message }}</small>
                                @enderror
                        </div>

                        <div class="mb-3">
                            <button type="submit"
                                class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                Update
                            </button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
</x-app-layout>