<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
             
                @php
                    $amount_claim = 0;
                    $total_gifts = 0;
                    $company = auth()->user()->company;
                    $company->companyclaim = \App\Models\Claim::first();
                    if (collect($company->companyclaim)->count() > 0) {
                        $claim_id = $company->companyclaim->id;
                        $amount_claim = $company->companyclaim->amount_claim;
                        $user_claim_allowed = $company->companyclaim->user_claim_allowed;
                        $maximumclaim = $company->companyclaim->first_user;
                        $today = date('Y-m-d');
                        if (\Illuminate\Support\Facades\Auth::user() && $claim_id) {
                            //->where('company_id', $company->id)
                            $todayClaims = \App\Models\UserClaim::where('claim_id', $claim_id)
                                ->where('user_id', Auth::user()->id)
                                ->whereRaw("DATE(created_at) = '$today' ")
                                ->count();
                            $totalClaims = \App\Models\UserClaim::where('claim_id', $claim_id)
                                ->where('user_id', Auth::user()->id)
                                ->sum('amount');
                            if (
                                \Illuminate\Support\Facades\Auth::user()->type == 0 &&
                                $todayClaims < $user_claim_allowed &&
                                $totalClaims <= $maximumclaim
                            ) {
                                $amount_claim = (float) $amount_claim;
                            }
                        }
                    }
                    if (@$company->regulargifts && @$company->regulargifts->is_regular_free == 1) {
                        $total_gifts =
                            (collect($company->regulargifts)->count() > 0
                                ? $company->regulargifts->receipent_will_get +
                                    $company->regulargifts->buyer_will_get_first_time
                                : 0) + $amount_claim;
                    }
                @endphp
                <div class="bg-light">
                    <div class="container p-5">

                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title flex justify-between">
                                    <div>
                                        General Setting
                                    </div>
                                </h5>

                                <div class="grid grid-cols-2 gap-2">
                                    <div>
                                        <form action="{{ route('company.dashboard.update') }}" method="POST">
                                            @csrf
                                            {{-- Payout Days --}}
                                            <div class="mb-3">
                                                <label class="block font-medium text-sm text-gray-700" for="payout_days">
                                                    Day
                                                </label>
                                                <select name="payout_days"
                                                    class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                                    <option @if($payout_days == '0') selected @endif value="0">No day</option>
                                                    <option @if($payout_days == '1') selected @endif value="1">1 day</option>
                                                    <option @if($payout_days == '2') selected @endif value="5">5 days</option>
                                                    <option @if($payout_days == '3') selected @endif value="14">14 days</option>
                                                </select>
                                                @error('payout_days')
                                                    <span class="text-red-500">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            {{-- minimum order limit --}}
                                            <div class="mb-3">
                                                <label class="block font-medium text-sm text-gray-700" for="minimum_order_limit">
                                                    Minimum Order Limit
                                                </label>
                                                <input
                                                    class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                                    id="minimum_order_limit" type="number" name="minimum_order_limit" autofocus="autofocus"
                                                    value="{{ $minimum_order_limit }}">
                                                    @error('minimum_order_limit')
                                                        <small class="text-red-500">{{ $message }}</small>
                                                    @enderror
                                            </div>

                                            {{-- order processing time --}}
                                            <div class="mb-3">
                                                <label class="block font-medium text-sm text-gray-700" for="order_processing_time">
                                                    Order Processing Time
                                                </label>
                                                <input
                                                    class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                                    id="order_processing_time" type="number" name="order_processing_time" autofocus="autofocus"
                                                    value="{{ $order_processing_time }}">
                                                    @error('order_processing_time')
                                                        <small class="text-red-500">{{ $message }}</small>
                                                    @enderror
                                            </div>

                                            {{--  --}}
                                            <div class="mb-3">
                                                {{-- <label class="block font-medium text-sm text-gray-700" for="reason">
                                                    Size / Group
                                                </label> --}}
                                                <div class="flex gap-2">
                                                    <div class="flex items-center px-4 border border-gray-200 rounded ">
                                                        <input id="temporary_close" type="radio" value="3" name="status"
                                                            @if($status == 3) checked @endif class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                                        <label for="temporary_close"
                                                            class="w-full py-4 ml-2 text-sm font-medium text-gray-900 ">Temporary Close</label>
                                                    </div>
                                                    <div class="flex items-center px-4 border border-gray-200 rounded ">
                                                        <input id="coming_soon" type="radio" value="2" name="status"
                                                            @if($status == 2) checked @endif class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                                        <label for="coming_soon"
                                                            class="w-full py-4 ml-2 text-sm font-medium text-gray-900">Coming Soon</label>
                                                    </div>

                                                    <div class="flex items-center px-4 border border-gray-200 rounded ">
                                                        <input id="business_active" type="radio" value="1" name="status"
                                                            @if($status == 1) checked @endif class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                                        <label for="business_active"
                                                            class="w-full py-4 ml-2 text-sm font-medium text-gray-900">Business Active</label>
                                                    </div>
                        
                                                </div>
                        
                                            </div>

                                            <div class="mb-3">
                                                <button type="submit"
                                                    class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                                    Update
                                                </button>
                                            </div>
                                        </form>

                                    </div>
                                    <div class="mb-3">
                                        <div class="mx-auto" id="company-qr-code" style="width: 359px;text-align: center;padding: 50px;border: solid 0px white">
                                            <div style="padding: 20px 20px 0px 35px;">
                                                {{ QrCode::size(170)->backgroundColor(255, 255, 255)->generate(route('download.app') . '?type=business&id=' . auth()->user()->company->id) }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-app-layout>

<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>

<script>
    function printDiv1() {
        var printContents = document.getElementById("company-qr-code").innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = '<div id="printContainer">' + printContents + '</div>';
        window.print();

        document.body.innerHTML = originalContents;
    }

    function printDiv() {
        var element = document.getElementById("company-qr-code");

        html2canvas(element).then(function(canvas) {
            var link = document.createElement("a");
            link.href = canvas.toDataURL();
            link.download = "companyQrCode.png";
            link.click();
        });
    }
</script>
