<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Product') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">

            <nav class="flex mb-3" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="inline-flex items-center">
                        <a href="/business-app/dashboard"
                            class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600">
                            <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z">
                                </path>
                            </svg>
                            Home
                        </a>
                    </li>

                    <li aria-current="page">
                        <div class="flex items-center">
                            <svg class="w-3 h-3 text-gray-400 mx-1" aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 9 4-4-4-4"></path>
                            </svg>
                            <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Create Product</span>
                        </div>
                    </li>
                </ol>
            </nav>


            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <form @submit.prevent="submitCreateForm" method="POST" enctype="multipart/form-data">

                    <div class="grid grid-cols-2 gap-2 mb-3">

                        {{-- Category --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="product">
                                Category
                            </label>
                            <select v-model="form.category" name="category" autofocus=""
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                @foreach ($categories as $category)
                                    <option value="{{ $category->id }}">
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                            <small v-if="errors.category" class="text-red-500">@{{ errors.category[0] }}</small>
                        </div>

                        <!-- Name -->
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="name">
                                Name
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="name" type="text" name="name" v-model="form.name">
                            <small v-if="errors.name" class="text-red-500">@{{ errors.name[0] }}</small>
                        </div>

                        {{-- Menu --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="menu">
                                Menu
                            </label>
                            <select v-model="form.menu" name="menu" autofocus=""
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                @foreach ($menuTypes as $mtype)
                                    <option value="{{ $mtype->id }}">
                                        {{ $mtype->name }}
                                    </option>
                                @endforeach
                            </select>
                            <small v-if="errors.menu" class="text-red-500">@{{ errors.menu[0] }}</small>
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="description">
                                Description
                            </label>
                            <input
                                v-model="form.description"
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="description" type="text" name="description" autofocus="autofocus"
                                autocomplete="description">
                                <small v-if="errors.description" class="text-red-500">@{{ errors.description[0] }}</small>
                        </div>

                        <!-- Price -->
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="description">
                                Price
                            </label>
                            <input
                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="price" type="number" name="price" autofocus="autofocus"
                                autocomplete="price" v-model="form.price">
                                <small v-if="errors.price" class="text-red-500">@{{ errors.price[0] }}</small>
                        </div>

                        {{-- image --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="image">
                                Image
                            </label>
                            <input @change.prevent="handleImage" accept="image/*" name="image" class="p-2 block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none" id="image" type="file">
                            <small v-if="errors.image" class="text-red-500">@{{ errors.image[0] }}</small>
                            <img :src="image_url" alt="" width="100">
                        </div>

                    </div>

                    <div class="mb-5">
                        <label class="block font-medium text-sm text-gray-700" for="reason">
                            Size / Group
                        </label>

                        <div class="flex gap-2">
                            <div class="flex items-center px-4 border border-gray-200 rounded ">
                                <input id="no_option" type="radio" value="" v-model='form.option_type' name="size_or_group"
                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                <label for="no_option"
                                    class="w-full py-4 ml-2 text-sm font-medium text-gray-900 ">No Option</label>
                            </div>
                            <div class="flex items-center px-4 border border-gray-200 rounded ">
                                <input id="size" type="radio" value="size" v-model='form.option_type' name="size_or_group"
                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                <label for="size"
                                    class="w-full py-4 ml-2 text-sm font-medium text-gray-900 ">Size</label>
                            </div>
                            <div class="flex items-center px-4 border border-gray-200 rounded ">
                                <input id="group" type="radio" value="group" v-model='form.option_type' name="size_or_group"
                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                <label for="group"
                                    class="w-full py-4 ml-2 text-sm font-medium text-gray-900">Group</label>
                            </div>

                        </div>

                    </div>


                    <div v-if="form.option_type == 'size'" class="option-size-section mb-5">
                        <div>
                            <div class="flex items-center justify-between">
                                <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                                    Options
                                </h2>
                                <button
                                    @click.prevent="addNewSizeOption"
                                    class="bg-indigo-500 hover:bg-indigo-700 text-white py-1 px-2 rounded">
                                    <i class="fas fa-add"></i>
                                    Add New Option
                                </button>
                            </div>

                        </div>

                        <div v-for="(size, idx) in form.sizes" :key="idx">
                            <div class="my-3">
                                <hr>
                            </div>

                            <div class="grid grid-cols-2 gap-2 mb-3">

                                {{-- Size --}}
                                <div class="mb-3">
                                    <label class="block font-medium text-sm text-gray-700" for="product">
                                        Size
                                    </label>
                                    <select name="size[]" autofocus="" v-model="size.size"
                                        class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                        @foreach ($sizes as $size)
                                            <option value="{{ $size->id }}">
                                                {{ $size->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Size Price -->
                                <div class="mb-3">
                                    <label class="block font-medium text-sm text-gray-700" for="name">
                                        Size Price
                                    </label>
                                    <input
                                        v-model="size.price"
                                        class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                        id="name" type="text" name="size_price[]" autofocus="autofocus" autocomplete="name">
                                    @error('name')
                                        <small class="text-red-500">{{ $message }}</small>
                                    @enderror
                                </div>

                            </div>

                            <div v-for="(sizegroup, idxg) in size.groups" :key="idxg">
                                <div class="grid grid-cols-2 gap-2">

                                    {{-- Group --}}
                                    <div class="mb-3">
                                        <label class="block font-medium text-sm text-gray-700" for="product">
                                            Group
                                        </label>
                                        <select :name="`size_group[${size.size}]`" autofocus="" v-model="sizegroup.group"
                                            @change.prevent="(e) => filterSizeGroupOptions(e, idx, idxg)"
                                            class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                            @foreach ($optiongroups as $ogroup)
                                                <option value="{{ $ogroup->id }}">
                                                    {{ $ogroup->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Upto -->
                                    <div class="mb-3">
                                        <label class="block font-medium text-sm text-gray-700" for="upto">
                                            Upto
                                        </label>
                                        <input
                                            v-model="sizegroup.upto"
                                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                            id="upto" type="text" :name="`size_upto[${size.size}]`">
                                        @error('upto')
                                            <small class="text-red-500">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="flex items-center justify-between">
                                    <div class="flex items-center rounded ">
                                        <input type="hidden" :name="`is_required[${size.size}]`" v-model="sizegroup.is_required">
                                        <input :id="`size-required`+sizegroup.group" type="radio" value="1"
                                            class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 focus:ring-2" v-model="sizegroup.is_required">
                                        <label :for="`size-required`+sizegroup.group"
                                            class="w-full py-2 ml-2 text-sm font-medium text-gray-900 ">Required</label>
                                    </div>
                                    <div></div>
                                </div>


                                <div v-for="(sizeoption,soi) in sizegroup.options" :key="soi" class="flex items-center justify-between">
                                    <div class="flex items-center mb-4">
                                        <input v-model="sizeoption.is_checked" :name="`size_option[${size.size}][${sizegroup.group}]`" :id="`size-option`+sizeoption.id+sizegroup.group" type="checkbox" :value="sizeoption.id" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                        <label :for="`size-option`+sizeoption.id+sizegroup.group" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">@{{ sizeoption.name }}</label>
                                    </div>
                                    <div>$@{{ sizeoption.price }}</div>
                                </div>

                                <div class="my-3">
                                    <hr>
                                </div>


                            </div>
                            <div class="flex items-center justify-between">
                                <div></div>
                                <button
                                    @click.prevent="() => addNewSizeGroup(idx)"
                                    class="bg-indigo-500 hover:bg-indigo-700 text-white py-1 px-2 rounded">
                                    <i class="fas fa-add"></i>
                                    Add New Group
                                </button>
                            </div>



                        </div>

                        <small v-if="errors.sizes" class="text-red-500">@{{ errors.sizes[0] }}</small>
                    </div>
                    <div v-if="form.option_type == 'group'" class="option-group-section mb-5">
                        <div>
                            <div class="flex items-center justify-between">
                                <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                                    Options
                                </h2>
                                <div></div>
                            </div>

                        </div>

                        <div class="my-3">
                            <hr>
                        </div>

                        <div v-for="(group, jdx) in form.groups" :key="jdx">
                            <div class="grid grid-cols-2 gap-2">

                                {{-- Group --}}
                                <div class="mb-3">
                                    <label class="block font-medium text-sm text-gray-700" for="product">
                                        Group
                                    </label>
                                    <select name="group[]" autofocus="" v-model="group.group"
                                        @change.prevent="(e) => filterGroupOptions(e,jdx)"
                                        class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                        @foreach ($optiongroups as $ogroup)
                                            <option value="{{ $ogroup->id }}">
                                                {{ $ogroup->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Upto -->
                                <div class="mb-3">
                                    <label class="block font-medium text-sm text-gray-700" for="upto">
                                        Upto
                                    </label>
                                    <input
                                        class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                        id="upto" type="text" name="group_upto[]" autofocus="autofocus" autocomplete="upto" v-model="group.upto">
                                    @error('upto')
                                        <small class="text-red-500">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>

                            <div class="flex items-center justify-between">
                                <div class="flex items-center rounded ">
                                    <input type="hidden" name="is_required[]" v-model="group.is_required">
                                    <input :id="`group-required`+group.group" type="radio" value="1"
                                        class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 focus:ring-2" v-model="group.is_required">
                                    <label :for="`group-required`+group.group"
                                        class="w-full py-2 ml-2 text-sm font-medium text-gray-900 ">Required</label>
                                </div>
                                <div></div>
                            </div>

                            <div v-for="(groupoption,goi) in group.options" :key="goi" class="flex items-center justify-between">
                                <div class="flex items-center mb-4">
                                    <input v-model="groupoption.is_checked" :name="`group_option[${group.group}][]`" :id="`group-option`+groupoption.id+group.group" type="checkbox" :value="groupoption.id" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                    <label :for="`group-option`+groupoption.id+group.group" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">@{{ groupoption.name }}</label>
                                </div>
                                <div>$@{{ groupoption.price }}</div>
                            </div>

                            <div class="my-3">
                                <hr>
                            </div>
                        </div>

                        <div class="flex items-center justify-between">
                            <div></div>
                            <button
                                @click.prevent="addNewGroup"
                                class="bg-indigo-500 hover:bg-indigo-700 text-white py-1 px-2 rounded">
                                <i class="fas fa-add"></i>
                                Add New Group
                            </button>
                        </div>

                        <small v-if="errors.groups" class="text-red-500">@{{ errors.groups[0] }}</small>

                    </div>

                    <div class="mb-3">
                        <button type="submit"
                            class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                            Submit
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@push("scripts")
    <script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <script>
      const { createApp, ref } = Vue

      createApp({
        data() {
            return {
                options: @json($options ?? '[]'),
                image_url: '',
                form: {
                    submitting: false,
                    category: '',
                    menu: '',
                    name: '',
                    description: '',
                    price: '',
                    option_type: '',
                    image: '',
                    sizes: [
                        {
                            size: '',
                            price: '',
                            groups: [
                                {
                                    group: '',
                                    upto: '',
                                    is_required: '',
                                    options: []
                                }
                            ]
                        }
                    ],
                    groups: [
                        {
                            group: '',
                            upto: '',
                            is_required: '',
                            options: []
                        }
                    ],
                    // csrf: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                errors: {}
            }
        },
        created() {

        },
        methods: {
            handleImage: function(e){
                const file = e.target.files[0];
                this.form.image = file;
                const image_url = URL.createObjectURL(file);
                this.image_url = image_url;
            },
            submitCreateForm: async function () {
                this.form.submitting = true;
                const formData = new FormData();
                Object.keys(this.form).forEach(key => {
                    let d = this.form[key];
                    if(key == "sizes" || key == "groups"){
                        d = JSON.stringify(d);
                    }
                    formData.append(key, d);
                });
                try{
                    const res = await axios.post('/business-app/dashboard/product', formData);
                    this.form.submitting = false;
                    window.location.href = "/business-app/dashboard/product";
                }catch(err){
                    if(err.response && err.response.status == 422){
                        // console.log( err.response.data.errors);
                        this.errors = err.response.data.errors;
                    }
                    this.form.submitting = false;
                }
            },
            addNewSizeOption: function(){

                this.form.sizes.push({
                    size: '',
                    size_price: '',
                    groups: [
                        {
                            group: '',
                            upto: '',
                            is_required: '',
                            options: []
                        }
                    ]
                });
            },
            addNewSizeGroup: function(idx){
                this.form.sizes[idx].groups.push({
                    group: '',
                    upto: '',
                    is_required: '',
                    options: []
                });
            },
            addNewGroup: function(){
                this.form.groups.push({
                    group: '',
                    upto: '',
                    is_required: '',
                    options: []
                });
            },
            filterSizeGroupOptions: function(e, sizeIdx, groupIdx){
                const id = e.target.value;
                let options = [];
                this.options.forEach(opt => {
                    if(opt.option_group_id == id){
                        options.push({...opt, is_checked: false});
                    }
                });
                this.form.sizes[sizeIdx].groups[groupIdx].options = options;
            },
            filterGroupOptions: function(e, groupIdx){
                const id = e.target.value;
                let options = [];
                this.options.forEach(opt => {
                    if(opt.option_group_id == id){
                        options.push({...opt, is_checked: false});
                    }
                });
                this.form.groups[groupIdx].options = options;
            },
        },
      }).mount('#app')
    </script>
@endpush
</x-app-layout>
