<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Tax') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">

            {{-- Breadcrumb --}}
          <div class="flex justify-between items-center py-3">

            <nav class="flex" aria-label="Breadcrumb">
              <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                  <a href="/business-app/dashboard"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                      viewBox="0 0 20 20">
                      <path
                        d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z">
                      </path>
                    </svg>
                    Home
                  </a>
                </li>

                <li aria-current="page">
                  <div class="flex items-center">
                    <svg class="w-3 h-3 text-gray-400 mx-1" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                      fill="none" viewBox="0 0 6 10">
                      <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="m1 9 4-4-4-4"></path>
                    </svg>
                    <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Tax</span>
                  </div>
                </li>
              </ol>
            </nav>

          </div>

            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">


                <div class="bg-light">
                    <div class="container p-5">

                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title flex justify-between items-center">
                                    <div>
                                        Tax Settings
                                    </div>
                                    @if (count($taxes) == 0)
                                        <div>
                                            <a href="{{ route('tax.create') }}"
                                                class="bg-indigo-500 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                                                <i class="bi bi-plus-circle"></i>
                                                Add Tax
                                            </a>
                                        </div>
                                    @endif
                                </h5>

                                @if ($tax)
                                    <form action="{{ route('tax.update', $tax->id) }}" method="POST">
                                        @csrf
                                        @method("PUT")
                                        <!-- Tip -->
                                        <div class="mb-3">
                                            {{-- <label class="block font-medium text-sm text-gray-700" for="tax">
                                                Tax
                                            </label> --}}
                                            <input
                                                class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                                id="tax" type="text" name="tax" autofocus="autofocus"
                                                autocomplete="tax" value="{{ $tax->tax }}">
                                                @error('tax')
                                                    <small class="text-red-500">{{ $message }}</small>
                                                @enderror
                                        </div>

                                        <div class="mb-3">
                                            <button type="submit"
                                                class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                                Submit
                                            </button>
                                        </div>
                                    </form>
                                @endif

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</x-app-layout>
