<nav x-data="{ open: false }" class="bg-white border-b border-gray-100">
    <!-- Primary Navigation Menu max-w-7xl -->
    <div class="mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    @if (auth()->user()->company->logo)
                        <a href="{{ route('dashboard') }}">
                            <img src="{{ auth()->user()->company->logo }}" alt="" class="block h-9 w-auto fill-current text-gray-800">
                        </a>
                    @else
                        <a href="{{ route('dashboard') }}">
                            <img src="{{ asset('logo.png') }}" alt="" class="block h-9 w-auto fill-current text-gray-800">
                        </a>
                    @endif
                    
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                        {{ __('Dashboard') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('sales.index') }}" :active="request()->routeIs('sales.index')">
                        {{ __('Sales') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('discount.index') }}" :active="request()->routeIs('discount.index')">
                        {{ __('Discount') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('employees.index') }}" :active="request()->routeIs('employees.index')">
                        {{ __('Employees') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('tip.index') }}" :active="request()->routeIs('tip.index')">
                        {{ __('Tip') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('tax.index') }}" :active="request()->routeIs('tax.index')">
                        {{ __('Tax') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('area.index') }}" :active="request()->routeIs('area.index')">
                        {{ __('Area') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('menu-type.index') }}" :active="request()->routeIs('menu-type.index')">
                        {{ __('Menu Type') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('menu.index') }}" :active="request()->routeIs('menu')">
                        {{ __(' Business Hours') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('size.index') }}" :active="request()->routeIs('size.index')">
                        {{ __('Size') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('option-group.index') }}" :active="request()->routeIs('option-group.index')">
                        {{ __('Option Group') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('option.index') }}" :active="request()->routeIs('option.index')">
                        {{ __('Option') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('table.index') }}" :active="request()->routeIs('table.index')">
                        {{ __('Table') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('product.index') }}" :active="request()->routeIs('product.index')">
                        {{ __('Product') }}
                    </x-nav-link>

                    <x-nav-link href="{{ route('category.index') }}" :active="request()->routeIs('category.index')">
                        {{ __('Category') }}
                    </x-nav-link>

                </div>
            </div>

            <!-- Settings Dropdown -->
            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <div class="relative">
                   <div>
                      <button id="desktop-dropdown-btn" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
                         Ton
                         <div class="ms-1">
                            <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                               <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                         </div>
                      </button>
                   </div>
                   <div id="desktop-dropdown" class="hidden absolute z-50 mt-2 w-48 rounded-md shadow-lg ltr:origin-top-right rtl:origin-top-left end-0" >
                      <div class="rounded-md ring-1 ring-black ring-opacity-5 py-1 bg-white">
                          <a class="block w-full px-4 py-2 text-start text-sm leading-5 text-gray-700 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 transition duration-150 ease-in-out" href="{{ route('companyimage') }}">Upload Image</a>
                          <a class="block w-full px-4 py-2 text-start text-sm leading-5 text-gray-700 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 transition duration-150 ease-in-out" href="{{ route('company', auth()->user()->company->id) }}">Company Profile</a>
                         <a class="block w-full px-4 py-2 text-start text-sm leading-5 text-gray-700 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 transition duration-150 ease-in-out" href="{{ route('profile.edit') }}">Profile</a>
                         <!-- Authentication -->
                         <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <a class="block w-full px-4 py-2 text-start text-sm leading-5 text-gray-700 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 transition duration-150 ease-in-out" href="{{ route('logout') }}" 
                            onclick="event.preventDefault(); this.closest('form').submit();">Log Out</a>
                         </form>
                      </div>
                   </div>
                </div>
             </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path  class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                {{ __('Dashboard') }}
            </x-responsive-nav-link>
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf

                    <x-responsive-nav-link :href="route('logout')"
                            onclick="event.preventDefault();
                                        this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>

