<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Restaurant</title>

    {{-- <link rel="stylesheet" href="{{ asset('restaurant/style.css?v=1') }}"> --}}
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('restaurant/favicon.ico') }}">

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet" />


    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />


    @stack("styles")

    <!-- Scripts -->
    @vite(['resources/js/app.js'])
    <style>
        .bg-f9 {
            background: #f9f9f9 !important;
        }
        hr{
            border-top: 1px solid rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    
    @php
        $today = date('Y-m-d');
        $my_time = '02:00:00';
        $time_diff = strtotime(strftime('%F') . ' ' . $my_time) - time();

        $selectedDate = date('Y-m-d');
        if ($dayToAdd > 0) {
            $selectedDate = date('Y-m-d', strtotime("+$dayToAdd day"));
        }
        if (session()->get('reserve_pick_date')) {
            $selectedDate = session()->get('reserve_pick_date');
        }
    @endphp

    @if (!$reservation)
        <div class="appbar container">
            <div class="d-flex align-items-center justify-content-between py-3">
                <a href="{{ url('/company/'.$company->id) }}" class="btn btn-light rounded-circle btn-sm">
                    <i class="fa-solid fa-arrow-left"></i>
                </a>
                <div class="text-center">
                    <h1 class="h5 mb-0">{{ $company->name }}</h1>
                    <p>{{ $company->address_line_1 }}</p>
                </div>
                <div>

                </div>
            </div>
        </div>
        <div class="main-section">
            <div class="container">
                <div class="main-form">
                    @if (Session::has('error'))
                        <div class="alert alert-danger">
                            @if (Session::get('error') == 'Please Login First to reserve.')
                                Please <a href="{{ url('/sign-in') }}">Login</a> First to reserve.
                            @else
                                {{ Session::get('error') }}
                            @endif
                        </div>
                    @endif
                    @if (Session::has('success'))
                        <div class="alert alert-success">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                    <form action="{{ route('table.reserve') }}" method="post">
                        @csrf
                        <div class="mb-3">
                            <label for="party_size">Party Size</label>
                            <input type="number" class="form-control @error('party_size') is-invalid @enderror"
                                name="party_size" id="party_size"
                                value="{{ old('party_size', session()->get('reserve_party_size', 2)) }}">
                            @error('party_size')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="pick_date">Pick Date Time</label>

                            <input type="date" class="form-control @error('pick_date') is-invalid @enderror"
                                name="pick_date" id="pick_date" value="{{ old('pick_date', $selectedDate) }}"
                                min="{{ $selectedDate }}">
                            @error('pick_date')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="row  mb-3">
                            <div class="col-lg-6 col-md-8">
                                <div class="row" id="timeslot-content">

                                    {{-- @foreach ($slots as $i => $slot)
                                        <div class="col-md-4 col-lg-3 col-4">
                                            <label for="slot{{$i}}" class="btn btn-light border p-3 mb-2 time-slot" data-time="{{ $slot['start'] }}">
                                                <input type="radio" hidden name="pick_time" value="{{ $slot['start'] }}" id="slot{{$i}}">
                                                {{ date("h:iA", $slot['start']) }}
                                            </label>
                                        </div>
                                    @endforeach --}}


                                </div>
                                @error('pick_time')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="note">Note</label>
                            <textarea name="note" id="note" cols="30" rows="3"
                                class="form-control @error('note') is-invalid @enderror">{{ old('note', session()->get('reserve_note')) }}</textarea>
                            @error('note')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <input type="hidden" name="company_id" value="{{ $company->id }}">
                            <button type="submit" class="btn btn-success w-100 py-2 text-center">Book Now</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @else
        <div class="bg-f9">
            <div class="container py-5">
                <div class="row">
                    <div class="col-lg-6 mx-auto card p-4 border-0">
                        <div class="my-10">
    
                            <div class="card-title text-center margin-top margin-bottom my-3">
                                <h3 class="text-center mb-0">{{ $company->name }}</h3>
                                <p class="text-center">Thank you for your visit</p>
                            </div>
    
                            @if ($reservation)
                                <hr>
                                {{-- <h1 class="h4">Reservation Details:</h1> --}}
                                {{-- <div class="d-flex align-items-center">
                                        <strong>Name:</strong>
                                        <p class="mb-0 ms-2">{{ $reservation->user->name }}</p>
                                    </div> --}}
                                @if ($reservation->table_id)
                                    @php
                                        $table = \App\Models\Table::find($reservation->table_id);
                                    @endphp
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="d-flex align-items-center">
                                            <strong><i class="fa fa-cutlery" aria-hidden="true"></i></strong>
                                            <p class="mb-0 ms-2">{{ $table->name }}</p>
                                        </div>
    
                                        <div class="d-flex align-items-center">
                                            <strong><i class="fa fa-users" aria-hidden="true"></i></strong>
                                            <p class="mb-0 ms-2">{{ $reservation->party_size }}</p>
                                        </div>
                                    </div>
                                @endif
                                @if($reservation->datetime)
                                <div class="d-flex align-items-center">
                                    <strong><i class="fa-solid fa-clock"></i></strong>
                                    <p class="mb-0 ms-2">{{ date('m-d-Y h:iA', strtotime($reservation->datetime)) }}</p>
                                </div>
                                @endif
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="d-flex align-items-center">
                                        <strong><i class="fa fa-user" aria-hidden="true"></i></strong>
                                        <p class="mb-0 ms-2">{{ $reservation->user?->name }}</p>
                                    </div>
    
                                    <div class="d-flex align-items-center">
                                        <strong><i class="fa fa-phone" aria-hidden="true"></i></strong>
                                        <p class="mb-0 ms-2">{{ $reservation->user?->phone_number }}</p>
                                    </div>
                                </div>
    
                                @if ($reservation->notes)
                                    <div class="d-flex align-items-center">
                                        <strong><i class="fa-solid fa-note-sticky"></i></strong>
                                        <p class="mb-0 ms-2">{{ $reservation->notes }}</p>
                                    </div>
                                @endif
    
                                <hr>
                            @endif
    
                        </div>
                    </div>
    
                </div>
            </div>
        </div>
    @endif


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        $(document).ready(function() {

            $(document).on("click", ".time-slot", function() {
                $(".time-slot").removeClass("border-warning");
                $(this).addClass("border-warning");

            });


            function checkDisableList(currentTimestamp) {

                const timeSlots = document.getElementsByClassName('time-slot');
                for (let i = 0; i < timeSlots.length; i++) {
                    const slotTime = parseInt(timeSlots[i].dataset.time);

                    if (slotTime > (currentTimestamp / 1000)) {
                        timeSlots[i].classList.remove("disabled");
                    } else {
                        timeSlots[i].classList.add("disabled");
                    }

                }
            }

            const selectedDate = @json($selectedDate);
            getTimeSlots(selectedDate);
            // checkDisableList(new Date(selectedDate).getTime());

            $(document).on("change", "#pick_date", function(e) {
                getTimeSlots(e.target.value);
            });

            function getTimeSlots(day) {
                $.ajax({
                    url: "{{ route('webapi.businesshours', $company->id) }}?date=" + day,
                    type: "GET",
                    success: function(response) {
                        console.log(response.data);
                        let html = "";
                        let sessionTime = @json(session()->get('reserve_pick_time', ''));
                        if (response.data && response.data.length > 0) {
                            if (sessionTime == "") {
                                sessionTime = response.data[0].start;
                            }
                            response.data.forEach((element, i) => {

                                // const tm = new Date(parseInt(element.start) * 1000).toLocaleString('en-US', { hour: 'numeric', minute: 'numeric', hour12: true });

                                html += `<div class="col-md-4 col-lg-3 col-4">
                                            <label for="slot${i}" class="btn btn-light border p-3 mb-2 time-slot ${element.start == sessionTime ? 'border-warning' : ''}" data-time="${ element.start }">
                                                <input type="radio" hidden name="pick_time" value="${ element.start }" id="slot${i}" ${element.start == sessionTime ? 'checked' : ''}>
                                                ${ element.start_time }
                                            </label>
                                        </div>`;
                            });

                            // checkDisableList(day);
                        } else {
                            html += `<div class="col-md-4 col-lg-3 col-4">Not Available</div>`;
                        }
                        $("#timeslot-content").html(html);
                    },
                    error: function(err) {
                        console.log(err);
                    }
                });
            }
        });
    </script>

</body>
</html>
