<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>


    {{-- <link rel="stylesheet" href="{{ asset('restaurant/style.css?v=1') }}"> --}}
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('restaurant/favicon.ico') }}">

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet" />


    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />


    @stack("styles")

    <!-- Scripts -->
    
    <style>
        body{
            background: #F9F9FB;
        }

        #cc_number, #cc_expiry, #cc_cvv {
            padding: 0.7rem 0.75rem;
            border: 1px solid #CBD5E1;
            border-radius: 6px;
        }
    </style>
</head>

<body>
    <div class="container my-5">
        <div class="row my-5">
            <div class="col-md-6 mx-auto">
                <div class="card border-0 p-3">
                    <div class="card-header bg-white border-0">
                        <h6 class="fw-bold">Temp Business List</h6>
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            @foreach ($companies as $company)
                                <a href="{{ url("/company/temp/$company->id") }}" class="list-group-item list-group-item-action">{{ $company->name }}</a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>