<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Models\Setting;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();

        $schedule->call(function () {

            $offer_lock = Setting::where('key', 'offer_lock_release_time')->first();
            $is_offer_lock = time() > intval($offer_lock?->value) ? false : true;

            if(!$is_offer_lock){

                $setting = Setting::where('key', 'offers_left')->first();
            
                if($setting->value == 1){

                    // lock offer for 2 min
                    $offer_lock = Setting::where('key', 'offer_lock_release_time')->first();
                    if(!$offer_lock){
                        $offer_lock = new Setting();
                    }
                    $offer_lock->key = "offer_lock_release_time";
                    $offer_lock->value = time() + 2 * 60;
                    $offer_lock->save();

                    $setting->value = 20;
                    $setting->save();
                }else{
                    $setting->value = $setting->value - 1;
                }
                
                $setting->save();
                
            }

        })->everyMinute();

    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
