<?php

namespace App\Helpers;

use App\Models\Company;
use App\Models\PromoType;
use App\Models\User;
use App\Models\UserPromo;
use Illuminate\Support\Str;

class Helper
{

    public static function isPhoneValid($phone, $code)
    {
        try {
            $phoneUtil = \libphonenumber\PhoneNumberUtil::getInstance();
            $swissNumberProto = $phoneUtil->parse($phone, $code);
            return $phoneUtil->isValidNumber($swissNumberProto);
        } catch (\libphonenumber\NumberParseException $e) {
            return false;
        }
        return false;
    }

    public static function countryCodes()
    {
        return collect([[93, "AF"], [355, "AL"], [213, "DZ"], [684, "AS"], [376, "AD"], [244, "AO"], [264, "AI"], [672, "AQ"], [268, "AG"], [54, "AR"], [374, "AM"], [297, "AW"], [61, "AU"], [43, "AT"], [994, "AZ"], [242, "BS"], [973, "BH"], [880, "BD"], [246, "BB"], [375, "BY"], [32, "BE"], [501, "BZ"], [229, "BJ"], [441, "BM"], [975, "BT"], [591, "BO"], [387, "BA"], [267, "BW"], [55, "BR"], [246, "IO"], [284, "VG"], [673, "BN"], [359, "BG"], [226, "BF"], [257, "BI"], [855, "KH"], [237, "CM"], [1, "CA"], [238, "CV"], [345, "KY"], [236, "CF"], [235, "TD"], [56, "CL"], [86, "CN"], [61, "CX"], [61, "CC"], [57, "CO"], [269, "KM"], [682, "CK"], [506, "CR"], [385, "HR"], [53, "CU"], [599, "CW"], [357, "CY"], [420, "CZ"], [243, "CD"], [45, "DK"], [253, "DJ"], [767, "DM"], [849, "DO"], [670, "TL"], [593, "EC"], [20, "EG"], [503, "SV"], [240, "GQ"], [291, "ER"], [372, "EE"], [251, "ET"], [500, "FK"], [298, "FO"], [679, "FJ"], [358, "FI"], [33, "FR"], [689, "PF"], [241, "GA"], [220, "GM"], [995, "GE"], [49, "DE"], [233, "GH"], [350, "GI"], [30, "GR"], [299, "GL"], [473, "GD"], [671, "GU"], [502, "GT"], [1481, "GG"], [224, "GN"], [245, "GW"], [592, "GY"], [509, "HT"], [504, "HN"], [852, "HK"], [36, "HU"], [354, "IS"], [91, "IN"], [62, "ID"], [98, "IR"], [964, "IQ"], [353, "IE"], [1624, "IM"], [972, "IL"], [39, "IT"], [225, "CI"], [876, "JM"], [81, "JP"], [1534, "JE"], [962, "JO"], [7, "KZ"], [254, "KE"], [686, "KI"], [383, "XK"], [965, "KW"], [996, "KG"], [856, "LA"], [371, "LV"], [961, "LB"], [266, "LS"], [231, "LR"], [218, "LY"], [423, "LI"], [370, "LT"], [352, "LU"], [853, "MO"], [389, "MK"], [261, "MG"], [265, "MW"], [60, "MY"], [960, "MV"], [223, "ML"], [356, "MT"], [692, "MH"], [222, "MR"], [230, "MU"], [262, "YT"], [52, "MX"], [691, "FM"], [373, "MD"], [377, "MC"], [976, "MN"], [382, "ME"], [664, "MS"], [212, "MA"], [258, "MZ"], [95, "MM"], [264, "NA"], [674, "NR"], [977, "NP"], [31, "NL"], [599, "AN"], [687, "NC"], [64, "NZ"], [505, "NI"], [227, "NE"], [234, "NG"], [683, "NU"], [850, "KP"], [670, "MP"], [47, "NO"], [968, "OM"], [92, "PK"], [680, "PW"], [970, "PS"], [507, "PA"], [675, "PG"], [595, "PY"], [51, "PE"], [63, "PH"], [64, "PN"], [48, "PL"], [351, "PT"], [939, "PR"], [974, "QA"], [242, "CG"], [262, "RE"], [40, "RO"], [7, "RU"], [250, "RW"], [590, "BL"], [290, "SH"], [869, "KN"], [758, "LC"], [590, "MF"], [508, "PM"], [784, "VC"], [685, "WS"], [378, "SM"], [239, "ST"], [966, "SA"], [221, "SN"], [381, "RS"], [248, "SC"], [232, "SL"], [65, "SG"], [721, "SX"], [421, "SK"], [386, "SI"], [677, "SB"], [252, "SO"], [27, "ZA"], [82, "KR"], [211, "SS"], [34, "ES"], [94, "LK"], [249, "SD"], [597, "SR"], [47, "SJ"], [268, "SZ"], [46, "SE"], [41, "CH"], [963, "SY"], [886, "TW"], [992, "TJ"], [255, "TZ"], [66, "TH"], [228, "TG"], [690, "TK"], [676, "TO"], [868, "TT"], [216, "TN"], [90, "TR"], [993, "TM"], [649, "TC"], [688, "TV"], [340, "VI"], [256, "UG"], [380, "UA"], [971, "AE"], [44, "GB"], [1, "US"], [598, "UY"], [998, "UZ"], [678, "VU"], [379, "VA"], [58, "VE"], [84, "VN"], [681, "WF"], [212, "EH"], [967, "YE"], [260, "ZM"], [263, "ZW"]]);
    }

    public function getRegularGiftBalance(User $user)
    {
        if (empty(auth()->user()->company)) {
            return 0;
        }
        $company = Company::find(auth()->user()->company->id);
        $userPromos = UserPromo::where('type', PromoType::REGULAR)
            ->where(function ($query) {
                $query->orWhere('status', UserPromo::STATUS_COMPLETED)
                    ->orWhere('action', UserPromo::APPROVED);
            })
            ->where('user_id', $user->id)->get();

        $amountAvailable = $userPromos->filter(function ($item) {
            return $item->company_id == auth()->user()->company->id;
        })->sum(fn ($item) => $item->amount_available);

        return $amountAvailable;
    }

    public function getRegularGift(User $user)
    {
        if (empty(auth()->user()->company)) {
            return 0;
        }
        $userPromos =  UserPromo::where('type', PromoType::REGULAR)
            ->where(function ($query) {
                $query->orWhere('status', UserPromo::STATUS_COMPLETED)
                    ->orWhere('action', UserPromo::APPROVED);
            })
            ->where('user_id', $user->id)->get();

        $userPromos = $userPromos->filter(function ($item) {
            return $item->company_id == auth()->user()->company->id;
        })->map(function ($item) {
            $item->amount_available = $item->amount_available;
            $item->promo = ['status' => 1];
            return $item;
        });

        return $userPromos;
    }
    public function getRegularGiftByCompany(User $user,$company_id)
    {
        $userPromos =  UserPromo::where('type', PromoType::REGULAR)
            ->where(function ($query) {
                $query->orWhere('status', UserPromo::STATUS_COMPLETED)
                    ->orWhere('action', UserPromo::APPROVED);
            })
            ->where('user_id', $user->id)->get();

        $userPromos = $userPromos->filter(function ($item) use($company_id) {
            return $item->company_id == $company_id;
        })->map(function ($item) {
            $item->amount_available = $item->amount_available;
            $item->promo = ['status' => 1];
            return $item;
        });

        return $userPromos;
    }


    public function getRegularGiftBalanceCustomer(User $user, Company $company)
    {
        if (empty($company)) {
            return 0;
        }
        // $company = Company::find(auth()->user()->company->id);
        $userPromos = UserPromo::where('type', PromoType::REGULAR)
            ->where(function ($query) {
                $query->orWhere('status', UserPromo::STATUS_COMPLETED)
                    ->orWhere('action', UserPromo::APPROVED);
            })
            ->where('user_id', $user->id)->get();

        $amountAvailable = $userPromos->filter(function ($item) use ($company) {
            return $item->company_id == $company->id;
        })->sum(fn ($item) => $item->amount_available);

        return $amountAvailable;
    }

    public function getRegularGiftCustomer(User $user, Company $company)
    {
        if (empty($company)) {
            return 0;
        }
        $userPromos =  UserPromo::where('type', PromoType::REGULAR)
            ->where(function ($query) {
                $query->orWhere('status', UserPromo::STATUS_COMPLETED)
                    ->orWhere('action', UserPromo::APPROVED);
            })
            ->where('user_id', $user->id)->get();

        $userPromos = $userPromos->filter(function ($item) use ($company) {
            return $item->company_id == $company->id;
        })->map(function ($item) {
            $item->amount_available = $item->amount_available;
            $item->promo = ['status' => 1];
            return $item;
        });

        return $userPromos;
    }

    public static function getTempUserID(){

        $temp_user_id = session()->get("temp_user_id");
        if(!$temp_user_id){
            $temp_user_id = Str::random(20);
            session()->put("temp_user_id", $temp_user_id);
        }
        return $temp_user_id;
    }

    public static function sendSMS($phone_number, $text)
    {

        $basic  = new \Vonage\Client\Credentials\Basic(env('VONAGE_API_KEY', "646a42d2"),env('VONAGE_API_SECRET', "zoKwHHChspFy4Oq7"));
        $client = new \Vonage\Client($basic);

        $response = $client->sms()->send(
            new \Vonage\SMS\Message\SMS($phone_number, "12063415865", "$text")
        );

        $message = $response->current();

        if ($message->getStatus() == 0) {
            return true;
        } else {
            return false;
        }

    }


    Public static function getUserTimezone(){
  
        $ip = file_get_contents("http://ipecho.net/plain");
        $url = 'http://ip-api.com/json/'.$ip;
        $tz = file_get_contents($url);
        $tz = json_decode($tz,true)['timezone'];
    
        return $tz;
    }
}
