<?php

namespace App\Http\Controllers\Api\V11;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use App\Models\CustomerReservations;
use App\Notifications\PhoneVerificationCode;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Auth;
use App\Models\User;
use Illuminate\Support\Str;
use App\Models\CustomerStripeInfo;
use App\Models\GlobalDiscount;
use App\Models\UserGlobalDiscount;
use App\Repositories\DiscountClaimRepository;
use Cartalyst\Stripe\Stripe;
use Illuminate\Support\Facades\Http;

class AuthController extends Controller
{
    public function loginWithOtp(Request $request){

        $request->validate([
            "phone_number" => ["required"],
        ]);

        $phone_number = $this->getPhone($request->phone_number);
        $user = User::where('phone_number', $phone_number)->first();

        $dbverification_number = $user->unreadNotifications()->first()?->data['verfication_no'];

        if ($request->otp != $dbverification_number) {
            return response()->json([
                'message' => 'Invalid verification code!',
                'errors' => [
                    'phone_number' => ['Invalid verification code!']
                ]
            ], Response::HTTP_BAD_REQUEST);
        }else{
            \Auth::login($user);
        }


    }


    public function sendOtp($phone){

        $random_number = rand(1000, 9999);
        // $this->user->notify(new PhoneVerificationCode($random_number));

        session()->put("otp", $random_number);

        $is_sent = Helper::sendSMS($phone, "Your verification code is $random_number Never share this code");

        if ($is_sent) {
            return response()->json([
                'success' => true,
                'type' => 'otpsent',
                'message' => 'OTP sent successfully',
                'data' => null
            ], 200);
        } else {
            return response()->json([
                'success' => true,
                'type' => 'otpsent',
                'message' => 'Failed to send otp',
                'data' => null
            ], 422);
        }


    }

    public function getPhone($phone_number)
    {
        $phone_number = $phone_number;
        $phone_number = str_replace(' ', '', $phone_number);
        $phone_number = str_replace('-', '', $phone_number);
        $phone_number = str_replace('+', '', $phone_number);

        return $phone_number;
    }

    public function resendUserOtp(Request $request){

        $request->validate([
            "phone_number" => ["required"],
        ]);

        $phone_number = $this->getPhone($request->phone_number);

        $user = User::where('phone_number', $phone_number)->first();
        $user->unreadNotifications()->update([
            'read_at' => now()
        ]);

        $random_number = rand(1000, 9999);
        session()->put("otp", $random_number);

        $is_sent = Helper::sendSMS($phone_number, "Your verification code is $random_number Never share this code");

        if($is_sent){
            return response()->json([
                "success" => true,
                "message" => "OTP sent successfully"
            ], 200);
        }else{
            return response()->json([
                "success" => false,
                "message" => "Failed to sent otp"
            ], 422);
        }

    }

    public function customerSignup(Request $request){


        // $additional_rules = [];
        // if(!$request->cc_number || !$request->cc_expiry || !$request->cc_cvc){
        //     $additional_rules["card"] = ["required"];
        // }

        $request->validate([
            "name" => ["required", "string", "max:255"],
            "email" => ["required", "email", "unique:users"],
            "phone_number" => ["required", "unique:users"],
        ]);

        $phone_number = $request->dial_code.$request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);
        $phone_number = str_replace(' ', '', $phone_number);
        $phone_number = str_replace('(', '', $phone_number);
        $phone_number = str_replace(')', '', $phone_number);

        $user = User::where('phone_number', $phone_number)->first();
        if($user){
            return response()->json([
                "errors" => [
                    "phone_number" => ["User already exists with that phone number"]
                ]
            ], 422);
        }

        if(!$request->otpsent){
            return $this->sendOtp($phone_number);
        }

        if(!$request->otp){
            return response()->json([
                "errors" => [
                    "otp" => ["Please insert the Verification Code"]
                ]
            ], 422);
        }else if($request->otp != session()->get('otp')){
            return response()->json([
                "errors" => [
                    "otp" => ["Invaild Verification Code"]
                ]
            ], 422);
        }

        $name = $request->name;
        $email = $request->email;

        $user_type = User::TYPE_CUSTOMER;
        $user = User::create([
            "type" => $user_type,
            "email" => $email ?? "",
            "phone_number" => $phone_number,
            // "first_name" => $this->first_name,
            // "last_name" => $this->last_name,
            "name" => $name ?? "",
            'password' => \Hash::make(Str::random(8)),
        ]);

        if($user){

            if($request->from == "redeem_page"){
                $qr_photo = null;
                if($request->hasFile("qr_code")){
                    $qr_photo = $request->qr_code->store('/', 'public');
                    $qr_photo = asset("/storage/".$qr_photo);
                }

                $user_discount = new UserGlobalDiscount();
                $user_discount->user_id = $user->id;
                $user_discount->global_discount_id = null;
                $user_discount->credit_amount = $request->redeem_amount;
                $user_discount->redeem_code = $request->redeem_code;
                $user_discount->qr_code = $qr_photo;
                $user_discount->info_data = "150";
                $user_discount->save();
            }

            Auth::login($user);
            return response()->json([
                "type" => "signin",
                "success" => true,
                "message" => "Registered successfully",
                "user_id" => $user->id
            ], 200);
        }

        return response()->json([
            "success" => false,
            "message" => "Something wen't wrong"
        ], 422);



    }

    public function registerUserWithOtp(Request $request){

        $id = $request->id;
        $name = $request->name;
        $email = $request->email;
        $phone_number = $request->phone_number;
        $last_four = $request->last_four;

        $phone_number = str_replace(' ', '', $phone_number);
        $phone_number = str_replace('-', '', $phone_number);
        $phone_number = str_replace('+', '', $phone_number);

        $user_type = User::TYPE_CUSTOMER;
        $user = User::create([
            "type" => $user_type,
            "email" => $email ?? "",
            "phone_number" => $phone_number,
            // "first_name" => $this->first_name,
            // "last_name" => $this->last_name,
            "name" => $name ?? "",
            'password' => \Hash::make(Str::random(8)),
        ]);

        $stripe = new Stripe(config('stripe.secret'));

        $customer_stripe_id =  $stripe->customers()->create(['name' => $user->name, 'email' => $user->email , 'phone' => $user->phone_number]);
        $customer_stripe_customer_id =  $customer_stripe_id['id'];

        $customer_stripe_info = new CustomerStripeInfo();
        $customer_stripe_info->customer_id = $user->id;
        $customer_stripe_info->stripe_cus_id = $customer_stripe_customer_id;
        $customer_stripe_info->stripe_pm_id = $id;
        $customer_stripe_info->card_last_4_digits = $last_four;
        $customer_stripe_info->save();

        Auth::login($user);

    }

    // public function verifyOtp(Request){

    //     $phone_number = $request->phone_number;

    //     if($this->otp){
    //         $dbverification_number = $this->user->unreadNotifications()->first()?->data['verfication_no'];

    //         if ($this->otp != $dbverification_number) {
    //             $this->error = "Invalid OTP!";
    //         }else{
    //             \Auth::login($this->user);
    //             $this->claimDiscount( $this->order->company_id); // calculate discount if logged in
    //             $this->goto("paynow");
    //         }
    //     }else{
    //         $this->error = "Invalid OTP!";
    //     }
    // }

    public function addCard(Request $request){

        $request->validate([
            "cc_number" => ["required"],
            "cc_expiry" => ["required"],
            "cc_cvc" => ['required'],
            "zip_code" => ['required'],
        ]);

        $user = Auth::user();


        $customer_stripe_info = CustomerStripeInfo::where('customer_id', $user->id)->first();

        if(!$customer_stripe_info){

            $stripe = new Stripe(config('stripe.secret'));
            $customer_stripe_id =  $stripe->customers()->create(['name' => $user->name, 'email' => $user->email , 'phone' => $user->phone_number]);
            $customer_stripe_customer_id =  $customer_stripe_id['id'];

            $customer_stripe_info = new CustomerStripeInfo();
            $customer_stripe_info->customer_id = $user->id;
            $customer_stripe_info->stripe_cus_id = $customer_stripe_customer_id;
            // $customer_stripe_info->stripe_pm_id = $id;
            // $customer_stripe_info->card_last_4_digits = $last_four;
            $customer_stripe_info->save();
        }


        $stripe = new \Stripe\StripeClient(config('stripe.secret'));
        $parts = explode("/", $request->cc_expiry);

        try{
            $stripe->paymentMethods->create([
                'type' => 'card',
                'card' => [
                    'number' => $request->cc_number,
                    'exp_month' => $parts[0],
                    'exp_year' => $parts[1],
                    'cvc' => $request->cc_cvc,
                ],
            ]);
        }catch(\Exception $e){
            return response()->json([
                "errors" => [
                    "message" => [$e->getMessage()]
                ]
            ], 422);
        }

    }

    public function customerSignin(Request $request){

        $request->validate([
            "phone_number" => ["required"],
        ]);

        $phone_number = $request->dial_code.$request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);
        $phone_number = str_replace(' ', '', $phone_number);
        $phone_number = str_replace('(', '', $phone_number);
        $phone_number = str_replace(')', '', $phone_number);

        $user = User::where('phone_number', $phone_number)->first();
        if(!$user){
            return response()->json([
                "errors" => [
                    "phone_number" => ["No user found with that phone number"]
                ]
            ], 422);
        }

        if(!$request->otpsent){
            return $this->sendOtp($phone_number);
        }

        if(!$request->otp){
            return response()->json([
                "errors" => [
                    "otp" => ["Please insert the Verification Code"]
                ]
            ], 422);
        }else if($request->otp != session()->get('otp')){
            return response()->json([
                "errors" => [
                    "otp" => ["Invaild Verification Code"]
                ]
            ], 422);
        }

        Auth::login($user);

        $reservation    =  CustomerReservations::where('customer_id', $user->id)
                ->where("status", '<=',CustomerReservations::STATUS_ASSIGNED)
                ->first();

        return response()->json([
            "type" => "signin",
            "success" => true,
            "has_reservation" => $reservation != null,
            "message" => "Registered successfully"
        ], 200);

    }

    public function saveCard(Request $request){

        $pm_id = $request->pm_id;
        $last_four = $request->last_four;

        $user = Auth::user();
        $customer_stripe_info = CustomerStripeInfo::where('customer_id', $user->id)->first();
        $stripe = new Stripe(config('stripe.secret'));
        $customer_stripe_id =  $stripe->customers()->create(['name' => $user->name, 'email' => $user->email , 'phone' => $user->phone_number]);
        $customer_stripe_customer_id =  $customer_stripe_id['id'];

        $customer_stripe_info = new CustomerStripeInfo();
        $customer_stripe_info->customer_id = $user->id;
        $customer_stripe_info->stripe_cus_id = $customer_stripe_customer_id;
        $customer_stripe_info->stripe_pm_id = $pm_id;
        $customer_stripe_info->card_last_4_digits = $last_four;
        $customer_stripe_info->save();

        $stripe->paymentMethods()->attach($pm_id, $customer_stripe_info->stripe_cus_id);

        return response()->json([
            "type" => "signin",
            "success" => true,
            "message" => "Registered successfully"
        ], 200);
    }

    public function claim($company_id){

        $user = Auth::user();

        // $claim_repo = new DiscountClaimRepository();
        // $discount = $claim_repo->getActiveDiscount($company_id);

        $user_discount = new UserGlobalDiscount();
        $user_discount->user_id = $user->id;
        // $user_discount->global_discount_id = $discount->id;
        $user_discount->credit_amount = 50;
        $user_discount->save();

        return response()->json([
            "status" => "success",
            "message" => "Claimed successfully"
        ], 200);



        // if ($claim_repo->canClaim($user,$company_id)) {

        //     $claim_repo->createClaim($user,$company_id);
        //     $user->phone_verified_at = now();
        //     $user->save();

        //     return response()->json([
        //         "status" => "success",
        //         "message" => "Claimed successfully"
        //     ], 200);

        // }else{
        //     return response()->json([
        //         "status" => "error",
        //         "message" => "Something wen't wrong!"
        //     ], 500);
        // }
    }

    public function redeem(Request $request){

        $request->validate([
            "redeem_amount" => ['required'],
            "redeem_code" => ['required'],
            "qr_code" => ['required', 'file', 'mimes:jpg,png'],
        ]);

        // $discount = GlobalDiscount::findOrFail($request->discount_id);

        $user = User::find($request->user_id);

        $qr_photo = null;
        if($request->hasFile("qr_code")){
            $qr_photo = $request->qr_code->store('/', 'public');
            $qr_photo = asset("/storage/".$qr_photo);
        }

        $user_discount = new UserGlobalDiscount();
        $user_discount->user_id = $user->id;
        $user_discount->global_discount_id = null;
        $user_discount->credit_amount = $request->redeem_amount;
        $user_discount->redeem_code = $request->redeem_code;
        $user_discount->qr_code = $qr_photo;
        $user_discount->info_data = "150";
        $user_discount->save();

        return response()->json([
            "status" => "success",
            "message" => "Claimed successfully"
        ], 200);


    }

    public function userDetails(){

        $user = Auth::user();
        return new UserResource($user);
    }

    public function userLocationAddress(Request $request){
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=".$latitude.",".$longitude."&key=AIzaSyDwNQg9sgVAaC2eTRZJE6n2YCbOJOjEigQ";
        $res = Http::get($url);
        $json = $res->json();

        $formatted_address = $json["results"][0]["formatted_address"];
        return response()->json([
            "status" => "OK",
            "formatted_address" => $formatted_address
        ], 200);
    }

    public function addressToCoords(Request $request){

        $address = $request->address;
        $url = "https://maps.google.com/maps/api/geocode/json?address=$address&key=AIzaSyDwNQg9sgVAaC2eTRZJE6n2YCbOJOjEigQ";

        $res = Http::get($url);
        $json = $res->json();
        $lat = $json["results"][0]["geometry"]["location"]["lat"];
        $lng = $json["results"][0]["geometry"]["location"]["lng"];

        return response()->json([
            "status" => "OK",
            "latitude" => $lat,
            "longitude" => $lng,
        ], 200);
    }

    public function stripeInfos(){

        $stripeInfos = CustomerStripeInfo::where('customer_id', auth()->user()?->id)->get();
        return response()->json([
            "data" => $stripeInfos
        ],200);
    }
}
