<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\CartResource;
use App\Models\Cart;
use App\Models\CartProductOptions;
use App\Models\Company;
use App\Models\Product;
use App\Models\Tax;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Support\Str;


class CartController extends Controller
{

    public function myAddToCart(Request $request)
    {

        $user = \Auth::user();

        // Cart::where('user_id', $user->id)->delete();
        // CartProductOptions::where('user_id', $user->id)->delete();
        // CartDetails::where('user_id', $user->id)->delete();
        // $price          =   0;

        $reqProduct = $request->product;

        $product_id = $reqProduct['id'];
        $product = Product::find($product_id);

        $temp_user_id = request('temp_user_id');


        if($user){
            $cartItem = Cart::where('user_id', $user->id)->where('product_id', $product_id)->first();
        }else{
            $cartItem = Cart::where('temp_user_id', $temp_user_id)->where('product_id', $product_id)->first();
        }


        if(!$cartItem){

            $optionData = [];

            if($reqProduct['custom_size'] && count($reqProduct['custom_size']) > 0){
                foreach ($reqProduct['custom_size'] as $csize) {
                    foreach ($csize['custom_group'] as $cgroup) {
                        $d = [];
                        $d['options'] = [];
                        foreach($cgroup['options'] as $options){
                            if($options['is_checked'] == true){
                                array_push($d['options'], [
                                    'option_id' => $options['id'],
                                    'option_name' => \App\Models\Option::find($options['id'])?->name,
                                    'price' => $options['price'],
                                ]);
                            }
                        }
                        if(count($d['options']) > 0){
                            $d['group_id'] = $cgroup['id'];
                            $d['group_name'] = \App\Models\OptionGroup::find($cgroup['id'])?->name;
                            $d['size_id'] = $csize['id'];
                            $d['size_name'] = \App\Models\Size::find($csize['id'])?->name;
                            array_push($optionData, $d);
                        }
                    }
                }
            }else{
                foreach ($reqProduct['custom_group'] as $cgroup) {
                    $d = [];
                    $d['options'] = [];
                    foreach($cgroup['options'] as $options){
                        if($options['is_checked'] == true){
                            array_push($d['options'], [
                                'option_id' => $options['id'],
                                'option_name' => \App\Models\Option::find($options['id'])?->name,
                                'price' => $options['price'],
                            ]);
                        }
                    }
                    if(count($d['options']) > 0){
                        $d['group_id'] = $cgroup['id'];
                        $d['group_name'] = \App\Models\OptionGroup::find($cgroup['id'])?->name;
                        $d['size_id'] = null;
                        $d['size_name'] = null;
                        array_push($optionData, $d);
                    }
                }
            }

            $cart = Cart::create([
                "user_id"    => $user?->id,
                "product_id" => $product_id,
                "company_id" => $product->company_id,
                "name"       => $product->name,
                "price"      => $product->price,
                "quantity"   => 1,
                "toppings"   => '',
                'temp_user_id' => $temp_user_id,
                'option_data' => json_encode($optionData)
            ]);

        }else{
            $cartItem->quantity = $cartItem->quantity + 1;
            $cartItem->save();
        }
        // foreach ($request->all() as $val) {
        //     $price += $val['price'];
        //     $cart = Cart::insertGetId([
        //         "user_id"    => $user->id,
        //         "product_id" => $val['product_id'],
        //         "company_id" => $val['company_id'],
        //         "name"       => $val['name'],
        //         "price"      => $val['price'],
        //         "quantity"   => $val['quantity'],
        //         "toppings"   => $val['toppings'] ? $val['toppings'] : ''
        //     ]);
        //     foreach ($val['options'] as $option) {
        //         $price += $option['price'];
        //         CartProductOptions::create([
        //             "cart_id"           => $cart->id,
        //             "user_id"           => $user->id,
        //             "product_id"        => $option['product_id'],
        //             "company_id"        => $option['company_id'],
        //             "size_id"           => $option['size_id'],
        //             "price"             => $option['price'],
        //             "option_group_id"   => $option['option_group_id'],
        //             "group_options"     => json_encode($val['group_options']),
        //         ]);
        //     }
        // }

        // CartDetails::create([
        //     'user_id'       => $user->id,
        //     'discount'      => $request->discount,
        //     'new_sub_total' => round(($price - $request->discount), 2),
        //     'tip'           => $request->tip,
        //     'tax'           => $request->tax,
        //     'total'         => round(($price + $request->tip + $request->tax) - ($request->discount), 2)
        // ]);

        return response()->json([
            'success' => true,
            'message' => "Successfully added to cart",
        ], 200);

    }

    public function updateMyCart(Request $request)
    {

        $user = \Auth::user();

        $product_id = $request->product_id;
        $product = Product::find($product_id);

        $temp_user_id = $request->temp_user_id;

        // if($user){
        //     $cartItem = Cart::where('user_id', $user->id)->where('product_id', $product_id)->first();
        // }else{
        // }
        $cartItem = Cart::where('temp_user_id', $temp_user_id)->where('product_id', $product_id)->first();

        $action_type = request("action_type");

        if($action_type == "+"){
            $cartItem->quantity = $cartItem->quantity + 1;
            $cartItem->save();
        }else{
            if($cartItem->quantity == 1){
                $cartItem->delete();
            }else{
                $cartItem->quantity = $cartItem->quantity - 1;
                $cartItem->save();
            }

        }

        return response()->json([
            'success' => true,
            'message' => "Successfully added to cart",
        ], 200);

    }

    public function getAllCart(){
        // $user = \Auth::user();
        $user = null;
        $temp_user_id = request('temp_user_id');

        $cartItems = Cart::where('temp_user_id', $temp_user_id)
                ->get()->groupBy('company_id');

        $data = [];
        foreach ($cartItems as $company_id => $carts) {

            $product_names = [];
            foreach ($carts as $cart) {
                array_push($product_names, $cart->product->name);
            }

            $company = Company::find($company_id);
            array_push($data, [
                "company_id" => $company->id,
                "company_name" => $company->name,
                "company_address" => $company->address_line_1,
                "product_names" => join(", ", $product_names)
            ]);
        }

        return response()->json([
            "data" => $data
        ], 200);
    }

    public function getMyCart(){


        // $user = \Auth::user();
        $user = null;
        $temp_user_id = request('temp_user_id');
        $company_id = request('company_id');
        // $temp_user_id = session()->get("temp_user_id");
        // if(!$temp_user_id) $temp_user_id = request('temp_user_id');
        // if($temp_user_id){
        //     Cart::where('temp_user_id', $temp_user_id)->where('user_id', null)->update([
        //         'user_id' => $user->id
        //     ]);
        // }

        // $visitedCompany = \Cookie::get('company');
        // $visitedCompany = session('company_id');
        // $company_id = $visitedCompany;

        // if($user){
        //     $cartItems = Cart::where('user_id', $user->id)->where('company_id', $company_id)->get();
        // }else{
        // }
        $cartItems = Cart::where('temp_user_id', $temp_user_id)->where('company_id', $company_id)->get();

        $tax = Tax::where('company_id', $company_id)->first();

        $subtotal = 0;
        $discount = 0;
        $tip = 0;
        $taxes = 0;
        $total = 0;
        foreach ($cartItems as $cartItem) {
            $subtotal += $cartItem->quantity * $cartItem->price;

            $cartOptions = json_decode($cartItem->option_data);
            foreach ($cartOptions as $copt){
                // $size = \App\Models\Size::where('id', $copt->size_id)->first();
                // $pprice = \App\Models\ProductPrice::where('size_id', $copt->size_id)->first();
                // $optionGroup = \App\Models\OptionGroup::where('id', $copt->group_id)->first();
                // $options = \App\Models\Option::whereIn('id', array_column($copt->options, "option_id"))->get();
                foreach ($copt->options as $op){
                    $subtotal += $op->price ?? 0;
                }
            }

        }

        // tax calculation
        $taxPercentage = $tax->tax ?? 0;
        $taxes = $subtotal * ($taxPercentage / 100);

        // discount calculation
        $user = \Auth::user();


        $claim_repo = new DiscountClaimRepository();
        $this->claim_discount = $user == null ? 0 : $claim_repo->discountAmount($user , $subtotal, $company_id);


        $total = $subtotal + $taxes + $total - $discount;

        return response()->json([
            "subtotal" => "$".$subtotal,
            "discount" => "$".$discount,
            "tip" => "$".$tip,
            "taxes" => "$".$taxes,
            "total" => "$".$total,
            "cart_items" => CartResource::collection($cartItems)
        ]);
    }


}
