<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Request;

class ClaimController extends Controller
{
    public function claimDiscount(Request $request){

        $request->validate([
            'company_id' => 'required|numeric|exists:App\Models\Company,id',
        ]);

        if (auth('sanctum')->user()) {
            $claim_repo = new DiscountClaimRepository();
            if($claim_repo->canClaim(auth('sanctum')->user(),$request->company_id)){
                $claim_repo->createClaim(auth('sanctum')->user(),$request->company_id);
                return response()->json([
                    'message'   =>  'Claim created successfully'
                ], 200);
            }
            return response()->json([
                'message'   =>  'Claim not available'
            ], 422);
        }else{
            return response()->json([
                'message'   =>  'Unauthenticated'
            ], 401);
        }
    }
}
