<?php

namespace App\Http\Controllers\Api\V11;

use Carbon\Carbon;
use App\Models\Company;
use App\Models\Discount;
use App\Models\DiscountHour;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Rules\PrimeTimeStartsAtRule;
use Illuminate\Support\Facades\Http;
use App\Http\Resources\CompanyResource;
use App\Http\Resources\DiscountResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\BusinessHoursResource;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\Company\StoreCompanyRequest;
use App\Http\Requests\Company\StripeConnectRequest;
use App\Models\CompanyType;
use App\Models\Product;

class CompanyController extends Controller
{

    public function index(Request $request)
    {

        $companies = Company::orderBy('created_at', 'desc');

        if($request->company_type){
            $company_type = CompanyType::where("name", "like", "%$request->company_type%")->first();
            $companies->where('type_id', $company_type?->id);
        }
        if($request->status){
            $companies->where('business_active', 1)->where('status', Company::STATUS_ACTIVE);
        }

        if($request->keyword){
            $company_ids = Product::where("name", "like", "%$request->keyword%")
                            ->orWhere("description", "like", "%$request->keyword%")
                            ->orWhere("options", "like", "%$request->keyword%")->pluck("company_id")->toArray();
            
           
            $companies->whereIn("id", $company_ids)
                        ->orWhere("name", "like", "%$request->keyword%")
                        ->orWhere("address_line_1", "like", "%$request->keyword%");
        }

        $companies = $companies->paginate(20);
        return CompanyResource::collection($companies);
    }

    public function nearByCompanies(Request $request)
    {

        $keyword = $request->keyword;

        if($request->keyword){
            $company_type = CompanyType::where("name", "like", "%$request->keyword%")->first();
            if($company_type){
                $keyword = $company_type?->name;
                $menuType = $company_type?->menuType;
                if($menuType){
                    $keyword .= " ".$menuType?->name;
                }
            }
         
        }else{
            $keyword = "Restaurant near me";
        }

        $location = [$request->latitude, $request->longitude]; //40.712776,-74.005974
        $apiKey = config('services.google_places.key', 'AIzaSyAXGwpMIHYkosnFKTpEKBGURETJyLxVSKI');
        $parameters = [
            'location' => implode(',', $location),
            'radius' => 16100,
            // 'type' => $request->type,
            'keyword' => $keyword,
            'key' => $apiKey,
        ];
        if ($request->pagetoken) {
            $parameters['pagetoken'] =  $request->pagetoken;
        }

        $response = Http::get(config('services.google_places.base_uri', 'https://maps.googleapis.com/maps/api/place/nearbysearch/json?' . http_build_query($parameters)));
        
        // You might want to handle the response better, depending on your needs, e.g., error handling.
        if ($response->successful()) {
            $json = $response->json();

            $data = [];
            foreach ($json['results'] as $result) {
                $name = $result['name'];
                $reservation_count = Company::where('name', $name)->where("company_type", "temp")->count();
                $companyDetails = $this->nearByCompanyDetails($result['place_id']);
                $newresult = array_merge($result, [
                    "reservations" => $reservation_count,
                    "opening_hours" => array_key_exists("opening_hours", $companyDetails['result']) ? $companyDetails['result']['opening_hours'] : null
                ]);
                array_push($data, $newresult);
            }
            
            return response()->json([
                "status" => $json['status'],
                "results" => $data,
                "next_page_token" => isset($json['next_page_token']) ? $json['next_page_token'] : null
            ], 200);
        } else {
            // Handle errors, for example, return an error message or log it
            return response()->json(['error' => 'Failed to fetch data from Google Places API'], 500);
        }
    }
    public function companyDetails($company_id)
    {
        $company = Company::where('id', $company_id)->first();
        return new CompanyResource($company);
    }

    public function nearByCompanyDetails($company_id)
    {
        $apiKey = config('services.google_places.key', 'AIzaSyAXGwpMIHYkosnFKTpEKBGURETJyLxVSKI');
        $parameters = [
            'place_id' => $company_id,
            'key' => $apiKey,
        ];
        $response = Http::get('https://maps.googleapis.com/maps/api/place/details/json?' . http_build_query($parameters));

        // You might want to handle the response better, depending on your needs, e.g., error handling.
        if ($response->successful()) {
            return $response->json();
        } else {
            // Handle errors, for example, return an error message or log it
            return response()->json(['error' => 'Failed to fetch data from Google Places API'], 500);
        }
    }
    public function businessHours($company_id)
    {

        $company = Company::findOrFail($company_id);

        if ($company->business_timezone) {
            date_default_timezone_set($company->business_timezone);
        }

        $date = request("date");
        $dayNumber = date('N', strtotime($date));
        $today = date('Y-m-d', strtotime('now'));
        $business_hours = $company->businesshours()->where('day', $dayNumber)->get();


        if (count($business_hours) > 0) {
            $startHour = $business_hours[0]->from;
            $endHour = $business_hours[count($business_hours) - 1]->to;

            $sh = strtotime(strftime("%F") . ' ' . $startHour);
            $eh = strtotime(strftime("%F") . ' ' . $endHour);

            $slots = [];
            for ($i = $sh; $i <= $eh;) {
                $end = $i + 15 * 60;
                if ($i < time() && $today == $date) {
                    $i = $end;
                    $sh = $i;
                    continue;
                }
                array_push($slots, [
                    "start" => $sh,
                    "end" => $end,
                    "start_time" => date("h:i A", $sh),
                    "end_time" => date("h:i A", $end),
                ]);
                $sh = $end;
                $i = $sh;
            }

            // $slots = [];
            // while($sh < $eh){
            //     dd($sh, time());
            //     // if($sh < time()) continue;
            //     $end = $sh + 15 * 60;
            //     array_push($slots, [
            //         "start" => $sh,
            //         "end" => $end,
            //         "start_time" => date("h:i A", $sh),
            //         "end_time" => date("h:i A", $end),
            //     ]);
            //     $sh = $end;
            // }
            return response()->json([
                "data" => $slots
            ]);
        }

        return response()->json([
            "data" => []
        ]);
        // return BusinessHoursResource::collection($business_hours);
    }


    public function getCompanyDiscounts()
    {
        $discounts = Discount::where('company_id', auth()->user()->company->id)->paginate(20);
        return DiscountResource::collection($discounts);
    }

    public function getCompanyDiscount($id)
    {

        $discount = Discount::where('company_id', auth()->user()->company->id)
            ->where('id', $id)->first();
        return new DiscountResource($discount);
    }

    public function deleteCompanyDiscount($id)
    {
        $discount = Discount::where('company_id', auth()->user()->company->id)
            ->where('id', $id)->delete();

        return response()->json([
            "success" => $discount,
            "message" => "Deleted Successfully",
            // "data" => null
        ], Response::HTTP_OK);
    }

    public function createCompanyDiscount(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'user_timezone' => ['required'],
            'name' => ["required"],
            'starts_at' => 'required',
            'credit_amount' => 'required',
            'pause_discount' => 'nullable',
            'percentage_off' => 'required',
            'limit_claims' => 'required',
            'maximum_discount' => 'nullable',
            'total_number_of_discount' => 'required',
        ]);

        $errors = $validator->errors()->toArray();
        if ($request->prime_time) {

            if ($request->prime_time == 'schedule' && !$request->prime_starts_at) {
                $errors['prime_starts_at'] = ["Prime Time starts at is required"];
            }

            if (!$request->prime_total_hours) {
                $errors['prime_total_hours'] = ["Prime Time Total Hours is required"];
            }

            if (!$request->prime_percentage_off) {
                $errors['prime_percentage_off'] = ["Prime Percentage off is required"];
            }
        }


        if ($request->percentage_off >= 15 && $request->percentage_off <= 25 && $request->credit_amount <= 100) {
            $errors['credit_amount'] = ["Credit amount must be greater than 100"];
        } else if ($request->percentage_off >= 30 && $request->percentage_off <= 50 && $request->credit_amount <= 50) {
            $errors['credit_amount'] = ["Credit amount must be greater than 50"];
        } else if ($request->percentage_off >= 51 && $request->percentage_off <= 90 && $request->credit_amount <= 30) {
            $errors['credit_amount'] = ["Credit amount must be greater than 30"];
        }

        $credit_amount = $request->credit_amount;
        $off = 0;
        if ($request->percentage_off >= 15 && $request->percentage_off <= 25) {
            $off = $credit_amount * (95 / 100);
        } else if ($request->percentage_off >= 30 && $request->percentage_off <= 50) {
            $off = $credit_amount * (90 / 100);
        } else if ($request->percentage_off >= 51 && $request->percentage_off <= 90) {
            $off = $credit_amount * (80 / 100);
        }

        $payAmount = $credit_amount - $off;


        if ($request->maximum_discount && $payAmount > $request->maximum_discount / 2) {
            // this.form.pay_amount = this.form.maximum_discount;
            $errors['maximum_discount'] = ["Maximum discount must be 2x of paying amount"];
        }

        if (count($errors) > 0) {
            return response()->json($errors, 422);
        }


        // $company = auth()->user()->company;
        // if ($company->business_timezone) {
        //     date_default_timezone_set($company->business_timezone);
        // }
        $user_timezone = $request->user_timezone;
        $starts_at = Carbon::parse($request->starts_at, $user_timezone)->setTimezone('UTC');

        $end_date = null;
        if ($request->pause_discount) {
            $end_date = Carbon::now();
        }


        \DB::beginTransaction();
        try {
            $discount = Discount::create([
                'company_id' => auth()->user()->company->id,
                'name' => $request->name,
                'starts_at' => $starts_at,
                'ends_at' => $end_date,
                'terms' => $request->percentage_off,
                'max_users' => $request->limit_claims,
                'amount' => $request->credit_amount,
                'max_discount_per_order' => $request->percentage_off > 30 ? $request->maximum_discount : null,
                'total_no_of_discounts' => $request->total_number_of_discount,
                "pt_type" => $request->prime_time,
                "pt_starts_at" => $request->prime_time == "now" ? Carbon::now() : $request->prime_starts_at,
                "pt_total_hours" => $request->prime_total_hours,
                "pt_percentage" => $request->prime_percentage_off,
                "pt_paying_amount" => $payAmount,
                // "is_global" => $request->is_global ? true : false
            ]);

            if ($request->prime_time == "prize_hour" && $request->prize_hours && count($request->prize_hours) > 0) {
                foreach ($request->prize_hours as $phour) {
                    if ($phour['day'] && $phour['starts_at'] && $phour['ends_at']) {
                        DiscountHour::create([
                            "discount_id" => $discount->id,
                            "day" => $phour['day'],
                            "starts_at" => $phour['starts_at'],
                            "ends_at" => $phour['ends_at']
                        ]);
                    }
                }
            }

            \DB::commit();
            return response()->json([
                "success" => true,
                "message" => "Created Successfully",
                // "data" => null
            ], Response::HTTP_OK);
        } catch (\Exception $e) {
            \DB::rollback();
            throw $e;
        }
    }


    public function updateCompanyDiscount($id, Request $request)
    {

        $validator = Validator::make($request->all(), [
            'name' => ["required"],
            'starts_at' => 'required',
            'credit_amount' => 'required',
            'pause_discount' => 'nullable',
            'percentage_off' => 'required',
            'limit_claims' => 'required',
            'maximum_discount' => 'nullable',
            'total_number_of_discount' => 'required',
        ]);

        $errors = $validator->errors()->toArray();
        if ($request->prime_time) {

            if ($request->prime_time == 'schedule' && !$request->prime_starts_at) {
                $errors['prime_starts_at'] = ["Prime Time starts at is required"];
            }

            if (!$request->prime_total_hours) {
                $errors['prime_total_hours'] = ["Prime Time Total Hours is required"];
            }

            if (!$request->prime_percentage_off) {
                $errors['prime_percentage_off'] = ["Prime Percentage off is required"];
            }
        }


        if ($request->percentage_off >= 15 && $request->percentage_off <= 25 && $request->credit_amount <= 100) {
            $errors['credit_amount'] = ["Credit amount must be greater than 100"];
        } else if ($request->percentage_off >= 30 && $request->percentage_off <= 50 && $request->credit_amount <= 50) {
            $errors['credit_amount'] = ["Credit amount must be greater than 50"];
        } else if ($request->percentage_off >= 51 && $request->percentage_off <= 90 && $request->credit_amount <= 30) {
            $errors['credit_amount'] = ["Credit amount must be greater than 30"];
        }

        $credit_amount = $request->credit_amount;
        $off = 0;
        if ($request->percentage_off >= 15 && $request->percentage_off <= 25) {
            $off = $credit_amount * (95 / 100);
        } else if ($request->percentage_off >= 30 && $request->percentage_off <= 50) {
            $off = $credit_amount * (90 / 100);
        } else if ($request->percentage_off >= 51 && $request->percentage_off <= 90) {
            $off = $credit_amount * (80 / 100);
        }

        $payAmount = $credit_amount - $off;


        if ($request->maximum_discount && $payAmount > $request->maximum_discount / 2) {
            // this.form.pay_amount = this.form.maximum_discount;
            $errors['maximum_discount'] = ["Maximum discount must be 2x of paying amount"];
        }

        if (count($errors) > 0) {
            return response()->json($errors, 422);
        }

        // $company = auth()->user()->company;
        // if ($company->business_timezone) {
        //     date_default_timezone_set($company->business_timezone);
        // }

        $user_timezone = $request->user_timezone;
        $starts_at = Carbon::parse($request->starts_at, $user_timezone)->setTimezone('UTC');


        $end_date = null;
        if ($request->pause_discount) {
            $end_date = Carbon::now();
        }

        $discount = Discount::find($request->id);
        $discount->update([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
            'starts_at' => $starts_at,
            'ends_at' => $end_date,
            'terms' => $request->percentage_off,
            'max_users' => $request->limit_claims,
            'amount' => $request->credit_amount,
            'max_discount_per_order' => $request->percentage_off > 30 ? $request->maximum_discount : null,
            'total_no_of_discounts' => $request->total_number_of_discount,
            "pt_type" => $request->prime_time,
            "pt_starts_at" => $request->prime_time == "now" ? Carbon::now() : $request->prime_starts_at,
            "pt_total_hours" => $request->prime_total_hours,
            "pt_percentage" => $request->prime_percentage_off,
            "pt_paying_amount" => $payAmount,
            // "is_global" => $request->is_global ? true : false
        ]);

        if ($request->prime_time == "prize_hour" && $request->prize_hours && count($request->prize_hours) > 0) {
            DiscountHour::where('discount_id', $discount->id)->delete();
            foreach ($request->prize_hours as $phour) {
                if ($phour['day'] && $phour['starts_at'] && $phour['ends_at']) {
                    DiscountHour::create([
                        "discount_id" => $discount->id,
                        "day" => $phour['day'],
                        "starts_at" => $phour['starts_at'],
                        "ends_at" => $phour['ends_at']
                    ]);
                }
            }
        }

        return response()->json([
            "success" => true,
            "message" => "Created Successfully",
            // "data" => null
        ], Response::HTTP_OK);
    }

    // public function companyDetails(){

    //     $company = auth()->user()->company;
    //     return new CompanyResource($company);

    // }

    public function saveBusinessSetting(Request $request)
    {

        $company = auth()->user()->company;


        $end_date = null;
        if ($request->pause_discount) {
            $end_date = Carbon::now();
        }

        Discount::create([
            'company_id' => $company->id,
            'name' => $request->name ?? "",
            'starts_at' => $request->starts_at ?: Carbon::now(),
            'ends_at' => $end_date,
            'terms' => $request->discount,
            'amount' => $request->gift_credit,
            "pt_paying_amount" => $request->pay_amount
        ]);

        return response()->json([
            "success" => true,
            "message" => "Created Successfully",
            // "data" => null
        ], Response::HTTP_OK);
    }



    public function startOnBoarding(StripeConnectRequest $request)
    {

        $user = auth()->user();

        $stripeSecretKey = config('stripe.secret');
        $stripe = new \Stripe\StripeClient(
            $stripeSecretKey
        );


        try {
            $token = $stripe->tokens->create([
                'bank_account' => [
                    'country' => 'US',
                    'currency' => 'usd',
                    'account_holder_name' => $request->account_holder,
                    'account_holder_type' => 'individual',
                    'routing_number' => $request->routing_number,
                    'account_number' => $request->account_number,
                ],
            ]);

            $token = $token->id;

            $account = $stripe->accounts->create([
                'type' => 'custom',
                'country' => 'US',
                'email' => $user->email,
                'capabilities' => [
                    'card_payments' => ['requested' => true],
                    'bank_transfer_payments' => ['requested' => true],
                    'transfers' => ['requested' => true],
                ],
            ]);

            // Get the seller's account ID from the response
            $seller_account_id = $account->id;

            $stripe->accounts->createExternalAccount(
                "$seller_account_id",
                ['external_account' => "$token"]
            );

            // update Database 
            $user->stripe_connect_id = $seller_account_id;
            $user->save();

            return response()->json([
                "success" => true,
                "message" => "Bank Account Connected Successfully"
            ], 200);
        } catch (\Exception $err) {
            return response()->json([
                "errors" => [
                    'message' => [$err->getMessage()]
                ]
            ], 422);
        }

        return;

        // stripe bank intent
        // $stripe->setupIntents->create([
        //     // 'customer' => '{{CUSTOMER_ID}}',
        //     'flow_directions' => ['outbound'],
        //     'payment_method_types' => ['us_bank_account'],
        // ]);

        // return 

        $account = $stripe->accounts->create([
            'type' => 'custom',
            'country' => 'US',
            'email' => $user->email,
            'capabilities' => [
                'card_payments' => ['requested' => true],
                'transfers' => ['requested' => true],
            ],
        ]);

        // Get the seller's account ID from the response
        $seller_account_id = $account->id;

        // update Database 
        $user->stripe_connect_id = $seller_account_id;
        $user->save();

        // Get the current date and IP address
        $current_date = time();
        $ip_address = $_SERVER['REMOTE_ADDR'];

        // Update the Stripe account agreement with the current date and IP address
        $tos = $stripe->accounts->update(
            $seller_account_id,
            ['tos_acceptance' => ['date' => $current_date, 'ip' => $ip_address]]
        );
        // Set the parameters for the account link
        $accountLinkParams = [
            'account' => $seller_account_id,
            'refresh_url' => url('/merchant-app/stripe-connect'),
            'return_url' => url('/business-app/dashboard'),
            'type' => 'custom_account_verification',
            'collect' => 'eventually_due',
        ];

        // Create the account link
        $accountLink = $stripe->accountLinks->create($accountLinkParams);

        return response()->json([
            "success" => true,
            "message" => "Stripe account connected successfully",
            "data" => $accountLink
        ], Response::HTTP_OK);
    }

    public function stripeConnectedAccounts()
    {

        $user = auth()->user();
        $stripe_connect_id = $user->stripe_connect_id;

        $stripeSecretKey = config('stripe.secret');
        $stripe = new \Stripe\StripeClient(
            $stripeSecretKey
        );
        $account = $stripe->accounts->retrieve($stripe_connect_id, []);

        return response()->json($account, 200);
    }

    
}
