<?php

namespace App\Http\Controllers\Api\V11;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\EgiftResource;
use App\Models\CustomerStripeInfo;
use App\Models\Egift;
use App\Models\Setting;
use App\Models\Transaction;
use App\Models\User;
use App\Models\UserGlobalDiscount;
use Cartalyst\Stripe\Stripe;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Str;

class EgiftConroller extends Controller
{
    public function buy(Request $request){

        if($request->for_whom == "someone"){
            $request->validate([
                "selected_amount" => ["required"],
                "phone_number" => ["required"],
                "full_name" => ["required"],
                "selected_account" => ["required"],
            ]);
            $phone_number = $request->dial_code.$request->phone_number;
            $phone_number = str_replace('-', '', $phone_number);
            $full_name = $request->full_name;
            $email = $request->email;
            $receipient = User::where('phone_number', $phone_number)->first();
        }else{
            $request->validate([
                "selected_amount" => ["required"],
                "selected_account" => ["required"],
            ]);
            $receipient = Auth::user();
            $phone_number = $receipient->phone_number;
            $full_name = $receipient->name;
            $email = $receipient->email;
        }

        if(!$receipient){
            $receipient = User::create([
                "type" => User::TYPE_CUSTOMER,
                "email" => $email ?? "",
                "phone_number" => $phone_number,
                // "first_name" => $this->first_name,
                // "last_name" => $this->last_name,
                "name" => $full_name ?? "",
                'password' => \Hash::make(Str::random(8)),
            ]);
        }

        $amount = $request->selected_amount;

        $extra_saving = floatval($amount * 1.5); // 150%
        $activation_fee = floatval($extra_saving * 0.075 + 0.30); // 7.5%

        $total_credit = $amount + $extra_saving;
        $total_pay = $amount + $activation_fee;

        $user = Auth::user();
        $customer_stripe_info = CustomerStripeInfo::where('id', $request->selected_account)->first();

        $customer_stripe_customer_id = $customer_stripe_info->stripe_cus_id;
        $customer_stripe_payment_id = $customer_stripe_info->stripe_pm_id;
        $chargeResult = $this->chargePayment($total_pay, $customer_stripe_customer_id , $customer_stripe_payment_id);

        if($chargeResult == true){

            $egift = Egift::create([
                'user_id' => $receipient->id,
                'customer_stripe_info_id' => $request->selected_account,
                'sender_id' => $user->id,
                'total_credit' => $total_credit,
                'gift_amount' => $amount,
                'extra_saving' => $extra_saving,
                'activation_fee' => $activation_fee,
                'total_pay' => $total_pay,
                'message' => $request->message
            ]);

            $user_discount = new UserGlobalDiscount();
            $user_discount->user_id = $receipient->id;
            // $user_discount->global_discount_id = $discount->id;
            $user_discount->credit_amount = $extra_saving;
            $user_discount->save();

            // Helper::sendSMS($receipient->phone_number, "Hello! You've received an E-gift sent by: Mr. $user->name. Please confirm with Mr. $user->name that you've received it. Visit pickgo.com for instructions on how to enjoy your gift. $request->message");
            // Helper::sendSMS($receipient->phone_number, "Hello! You've received a $$amount E-gift and $$extra_saving Extra Savings Gift Credit sent by Mr. $user->name. Please confirm with Mr. $user->name that you've received it.  instructions on how to enjoy your gift please visit pickgo.com \nPICKGO Smart Gifting - Multiply Your Generosity. Send Gifts, Get Extra! A single e-gift balance, usable everywhere at local businesses.");
            Helper::sendSMS($receipient->phone_number, "Hello! You've received a $$amount E-gift and $$extra_saving Extra Savings Gift Credit sent by Mr. $user->name. Please confirm with Mr. $user->name that you've received it. For instructions on how to enjoy your gift, please visit pickgo.com \n\nPICKGO Smart Gifting - Multiply Your Generosity. Send Gifts, Get Extra! A single e-gift balance, usable everywhere at local businesses.");
            
            $setting = Setting::where('key', 'offers_left')->first();
            
            if($setting->value == 1){

                // lock offer for 2 min
                $offer_lock = Setting::where('key', 'offer_lock_release_time')->first();
                if(!$offer_lock){
                    $offer_lock = new Setting();
                }
                $offer_lock->key = "offer_lock_release_time";
                $offer_lock->value = time() + 2 * 60;
                $offer_lock->save();

                $setting->value = 20;
            }else{
                $setting->value = $setting->value - 1;
            }
            $setting->save();
            
            return response()->json([
                "status" => "success",
                "message" => "Successfully bought",
                "data" => [
                    "egift_id" => $egift->id
                ]
            ], 200);
        }else{
            return response()->json([
                "status" => "failed",
                "message" => "Failed to bought"
            ], 500);
        }
    }

    public function chargePayment($total_amount, $customer_stripe_customer_id , $customer_stripe_payment_method_id)
    {
        $user = Auth::user();
        $stripe = new Stripe(config('stripe.secret'));

        $paymentIntent = $stripe->paymentIntents()->create([
            'amount' => $total_amount,
            'currency' => 'usd',
            'customer' => $customer_stripe_customer_id,
            'payment_method' => $customer_stripe_payment_method_id,
            // 'off_session' => true,
            'confirm' => true,
        ]);

        if (!empty($paymentIntent) && $paymentIntent["status"] == "succeeded") {

            $transaction = Transaction::create([
                'user_id' => $user->id,
                'charge_id' => $paymentIntent["charges"]["data"][0]["id"],
                'type' => Transaction::TYPE_E_GIFT,
                // 'company_id' => $discount->company_id,
                'amount' => $total_amount,
                'payment_intent_id' => $paymentIntent["id"]
            ]);

            return true;
        }

        return false;
    }

    public function egiftDetails($id){
        $egift = Egift::findOrFail($id);
        return new EgiftResource($egift);
    }

    public function confirmEgift(Request $request){

        $id = $request->id;
        $egift = Egift::findOrFail($id);
        $egift->is_confirmed = true;
        if($egift->save()){
            return response()->json([
                "status" => "success",
                "message" => "Egift Confirmed",
            ], 200);
        }else{
            return response()->json([
                "status" => "failed",
                "message" => "Failed to Confirm",
            ], 422);
        }
    }
}
