<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Resources\OrderResource;
use App\Models\Order;
use Illuminate\Http\Request;

class SalesController extends Controller
{
    public function index(){
        $authUser = auth()->user();
        $company = $authUser->company;
        $orders = Order::where("company_id", $company->id)->paginate(20);
        return OrderResource::collection($orders);
    }

    public function show($id){
        $authUser = auth()->user();
        $company = $authUser->company;
        $order = Order::where("id", $id)->where("company_id", $company->id)->first();
        return new OrderResource($order);
    }
}
