<?php

namespace App\Http\Controllers\BusinessApp;

use App\Models\User;
use App\Models\Company;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\RegularGiftSetting;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;


class DashboardController extends Controller
{

    public function index()
    {

        $company = auth()->user()->company;

        $data['companyId']            =   $company->id;
        $data['status']               =   $company->status;
        $data['payout_days']          =   $company->payouts_days;
        $data['minimum_order_limit']   =   $company->minimum_order_limit;
        $data['order_processing_time']   =   $company->order_processing_time;

        $data['gifts'] = RegularGiftSetting::where('company_id', auth()->user()->company->id)->paginate(20);

        return view('business-app.dashboard', $data);
    }


    public function updateDashboardSetting(Request $request){

        $request->validate([
            'status' => 'nullable',
            'payout_days' => 'required',
            'minimum_order_limit' => 'required|numeric',
            'order_processing_time' => 'required',
        ]);


        $company = auth()->user()->company;

        $company->update([
            'status'                => $request->status ?? 0,
            'temporary_close'       => $request->status == 3? 3:0,
            'coming_soon'           => $request->status == 2? 2:0,
            'business_active'       => $request->status == 1? 1:0,
            'payouts_days'          => $request->payout_days,
            'minimum_order_limit'    => $request->minimum_order_limit,
            'order_processing_time'    => $request->order_processing_time,
        ]);

        return redirect()->back()->with("success", "Settings Updated Successfully");
    }


    public function image()
    {
        $logo_url = auth()->user()->company->logo;
        $cover_url = auth()->user()->company->cover_photo;
        $banner_url = auth()->user()->company->banner_photo;
        return view('business-app.company-image', compact('logo_url', 'cover_url' ,'banner_url'));
    }

    public function uploadLogo(Request $request)
    {
        $request->validate([
            'logo' => 'required',
        ]);

        $company = auth()->user()->company;

        if($request->hasFile("logo")){
            $logo = $request->logo->store('/', 'public');
            $logo = asset("/storage/".$logo);

            $company->update([
                "logo" => $logo
            ]);

            return redirect()->back()->with("success", "Logo Updated Successfully");
        }

        return redirect()->back()->with("error", "Failed to Update Logo");
    }
    

    public function uploadCoverImage(Request $request)
    {

        $request->validate([
            'cover_image' => 'required',
        ]);
       
        $company = auth()->user()->company;

        if($request->hasFile("cover_image")){
            $cover_image = $request->cover_image->store('/', 'public');
            $cover_image = asset("/storage/".$cover_image);

            $company->update([
                "cover_photo" => $cover_image,
            ]);

            return redirect()->back()->with("success", "Cover Image Updated Successfully");
        }
        
        return redirect()->back()->with("error", "Failed to Update Cover Image");
    }
    
    public function uploadBannerImage(Request $request)
    {
        $request->validate([
            'banner_image' => 'required',
        ]);

        $company = auth()->user()->company;

        if($request->hasFile("banner_image")){
            $banner_image = $request->banner_image->store('/', 'public');
            $banner_image = asset("/storage/".$banner_image);

            $company->update([
                "banner_photo" => $banner_image
            ]);

            return redirect()->back()->with("success", "Banner Updated Successfully");
        }

        return redirect()->back()->with("error", "Failed to Update Banner");
    }

}
