<?php

namespace App\Http\Controllers\BusinessApp;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Discount;

class DiscountController extends Controller
{
    public function index()
    {
        $discounts = Discount::where('company_id', auth()->user()->company->id)->paginate(10);
        $user_timezone = Helper::getUserTimezone();

        return view('business-app.discount.index', compact('discounts', 'user_timezone'));
    }

    public function create()
    {
        return view('business-app.discount.create');
    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
            'price' => 'required'
        ]);

        Discount::create([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
            'price' => $request->price
        ]);

        return redirect()->route('discount.index')->with("success", "Discount Created Successfully!");

    }

    public function edit($id)
    {
        $discount = Discount::where('id', $id)->where('company_id', auth()->user()->company->id)->first();
        return view('business-app.discount.edit', compact('discount'));
    }

    public function update($id, Request $request){

        $request->validate([
            'name' => 'required',
            'price' => 'required',
        ]);

        $discount = Discount::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $discount->update([
            'name' => $request->name,
            'price' => $request->price,
        ]);

        return redirect()->route('discount.index')->with("success", "Discount Updated Successfully!");
    }

    public function destroy($id){

        $discount = Discount::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $discount->delete();

        return redirect()->route('discount.index')->with("success", "Discount Deleted Successfully!");

    }
  
}
