<?php

namespace App\Http\Controllers\BusinessApp;

use App\Models\Employee;
use App\Http\Controllers\Controller;
use App\Models\Area;
use Illuminate\Http\Request;

class EmployessController extends Controller
{
    public function index()
    {

        $employees = Employee::where('company_id', auth()->user()->company->id)->paginate(10);

        return view('business-app.employee.index', compact('employees'));
    }

    public function create(){

        $areas = auth()->user()->company->areas;
        return view('business-app.employee.create', compact('areas'));
    }

    public function store(Request $request){
        
        $request->validate([
            'name' => 'required',
            'role' => 'required',
            'access_area' => 'required|not_in:0',
        ]);

        if ($request->access_area != 0) {
            $area = Area::findOrFail($request->access_area);
        }

        $employee = Employee::create([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
            'role' => $request->role,
            'access' => $request->access_area != 0 ? json_encode($area->name) : json_encode($request->access_area)
        ]);

        $employee->areas()->attach($area->id);

        return redirect()->route('employees.index')->with("success", "Employee Created Successfully!");
        
    }

    public function edit($employee_id){

        $areas = auth()->user()->company->areas;
        $employee = Employee::where('company_id', auth()->user()->company->id)->where('id', $employee_id)->first();
        return view('business-app.employee.edit', compact('areas', 'employee'));
    }



    public function update($employee_id, Request $request)
    {
        $request->validate([
            'name' => 'required',
            'role' => 'required',
        ]);

        $employee = Employee::find($employee_id);

        if ($request->access_area != 0) {
            $area = Area::findOrFail($request->access_area);
            $employee->areas()->syncWithoutDetaching($area->id);
        }

        $employee->update([
            'name' => $request->name,
            'role' => $request->role,
            'access' => $request->access_area
        ]);

        return redirect()->route('employees.index')->with("success", "Employee Updated Successfully!");
    }



    public function destroy($employee_id){

        $employee = Employee::where('id', $employee_id)->where('company_id', auth()->user()->company->id)->first();
        
        $employee->delete();
        
        return redirect()->route('employees.index')->with("success", "Employee Deleted Successfully!");

    }















    public function employeelog(Employee $employee)
    {
        $employee_logs = $employee->employeeLogs->paginate(10);

        return view('business-app.employee_log', compact('employee_logs'));
    }

    public function addemployeeArea(Employee $employee)
    {
        // /return $employee->areas;
        $data['allArea'] = auth()->user()->company->areas;
        $data['createMode'] = false;
        $data['updateMode'] = false;
        $data['employees'] = Employee::where('company_id', auth()->user()->company->id)->paginate(10);
        $data['employee'] = $employee;

        return view('business-app.employee-area', $data);
    }
}
