<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use App\Models\MenuType;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function index(){

        $menus = Menu::where('company_id', auth()->user()->company->id)->get();
        return view('business-app.menu.index', compact('menus'));
    }

    public function create(){

        $menutypes = MenuType::where('company_id', auth()->user()->company->id)->get();
        return view('business-app.menu.create', compact('menutypes'));
    }

    public function store(Request $request){

        $request->validate([
            'menu_type_id' => 'required|not_in:0',
            'day' => 'required|numeric',
            'from' => 'required|date_format:H:i:s',
            'to' => 'required|date_format:H:i:s',
        ]);

        Menu::create([
            'company_id' => auth()->user()->company->id,
            'menu_type_id' => $request->menu_type_id,
            'day' => $request->day,
            'from' => $request->from,
            'to' => $request->to,
        ]);

        return redirect()->route('menu.index')->with(['success' => 'Created successfully']);

    }

    public function edit($menu_id){

        $menu = Menu::find($menu_id);
        $menutypes = MenuType::where('company_id', auth()->user()->company->id)->get();
        return view('business-app.menu.edit', compact('menu', 'menutypes'));
    }

    public function update($menu_id, Request $request){

        $request->validate([
            'menu_type_id' => 'required|not_in:0',
            'day'           => 'required|numeric',
            'from' => 'required|date_format:H:i:s',
            'to' => 'required|date_format:H:i:s',
        ]);

        $menu = Menu::find($menu_id);

        $menu->update([
            'menu_type_id' => $request->menu_type_id,
            'day' => $request->day,
            'from' => $request->from,
            'to' => $request->to,
        ]);


        return redirect()->route('menu.index')->with(['success' => 'Updated successfully']);

    }

    public function destroy($menu_id){

        $menu = Menu::find($menu_id);
        $menu->delete();

        return redirect()->route('menu.index')->with(['success' => 'Deleted successfully']);
    }
}
