<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\MenuType;
use Illuminate\Http\Request;

class MenuTypeController extends Controller
{
    public function index()
    {
        $menutypes = MenuType::where('company_id', auth()->user()->company->id)->paginate(20);
        return view('business-app.menutype.index', compact('menutypes'));
    }

    public function create()
    {
        return view('business-app.menutype.create');
    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
        ]);

        MenuType::create([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
        ]);

        return redirect()->route('menu-type.index')->with("success", "Menutype Created Successfully!");
    }
  
    public function edit($menutype_id)
    {
        return view('business-app.menutype.edit');
    }

    public function update($menutype_id, Request $request){

        $request->validate([
            'name' => 'required',
        ]);

        $menutype = MenuType::find($menutype_id);

        $menutype->update([
            'name' => $request->name,
        ]);

        return redirect()->route('menu-type.index')->with("success", "Menutype Updated Successfully!");
    }

    public function destroy($menutype_id){

        $menutype = MenuType::where('id', $menutype_id)->where('company_id', auth()->user()->company->id)->first();
        
        $menutype->delete();
        
        return redirect()->route('menu-type.index')->with("success", "Menutype Deleted Successfully!");

    }
}
