<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Option;
use Illuminate\Http\Request;

class OptionController extends Controller
{

    public function index(){

        $options = Option::where('company_id', auth()->user()->company->id)->paginate(20);

        return view('business-app.option.index', compact('options'));
    }

    public function create(){
        $optiongroups = auth()->user()->company->optionGroup;
        return view('business-app.option.create', compact('optiongroups'));
    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
            'price' => 'required|integer',
            'optiongroup' => 'required',
        ]);

        Option::create([
            'company_id' => auth()->user()->company->id,
            'option_group_id' => $request->optiongroup,
            'name' => $request->name,
            'price' => $request->price
        ]);

        return redirect()->route('option.index')->with("success", "Option Created Successfully!");

    }

    public function edit($id)
    {
        $option = Option::where('id', $id)->where('company_id', auth()->user()->company->id)->first();
        $optiongroups = auth()->user()->company->optionGroup;
        return view('business-app.option.edit', compact('option','optiongroups'));
    }

    public function update($id, Request $request){

        $request->validate([
            'name' => 'required',
            'price' => 'required',
        ]);

        $option = Option::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $option->update([
            'name' => $request->name,
            'price' => $request->price,
        ]);

        return redirect()->route('option.index')->with("success", "Option Updated Successfully!");
    }

    public function destroy($id){

        $option = Option::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $option->delete();

        return redirect()->route('option.index')->with("success", "Option Deleted Successfully!");

    }
}
