<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\OptionGroup;
use Illuminate\Http\Request;

class OptionGroupController extends Controller
{

    public function index(){
        $optiongroups = OptionGroup::where('company_id', auth()->user()->company->id)->paginate(20);
        return view('business-app.optiongroup.index', compact('optiongroups'));
    }

    public function create(){
        return view('business-app.optiongroup.create');
    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
        ]);

        OptionGroup::create([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
        ]);

        return redirect()->route('option-group.index')->with("success", "Option Group Created Successfully!");

    }

    public function edit($id)
    {
        $optiongroup = OptionGroup::where('id', $id)->where('company_id', auth()->user()->company->id)->first();
        return view('business-app.optiongroup.edit', compact('optiongroup'));
    }

    public function update($id, Request $request){

        $request->validate([
            'name' => 'required',
        ]);

        $optiongroup = OptionGroup::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $optiongroup->update([
            'name' => $request->name,
        ]);

        return redirect()->route('option-group.index')->with("success", "Option Group Updated Successfully!");
    }

    public function destroy($id){

        $optiongroup = OptionGroup::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $optiongroup->delete();

        return redirect()->route('option-group.index')->with("success", "Option Group Deleted Successfully!");

    }
}
