<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Menu;
use App\Models\Option;
use App\Models\OptionGroup;
use App\Models\Product;
use App\Models\ProductOption;
use App\Models\ProductOptionGroup;
use App\Models\ProductPrice;
use App\Rules\ProductGroupRule;
use App\Rules\ProductSizeRule;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class ProductController extends Controller
{
    public function index()
    {
        $products = Product::where('company_id', auth()->user()->company->id)->paginate(20);

        return view('business-app.product.index', compact('products'));
    }

    public function create(){

        $categories = Category::where('company_id',auth()->user()->company->id)->get();
        $menus = auth()->user()->company->menus;
        $menuTypes = auth()->user()->company->menuTypes;
        $sizes = auth()->user()->company->sizes;
        $options = Option::where('company_id', auth()->user()->company->id)->get();
        $optiongroups = OptionGroup::where('company_id',auth()->user()->company->id)->get();

        return view('business-app.product.create', compact('categories', 'menus', 'menuTypes', 'sizes', 'options', 'optiongroups'));
    }



    public function store(Request $request)
    {

        $request->validate([
            'name' => 'nullable|string',
            'category' => 'required',
            'menu' => 'required',
            'price' => 'required',
            "sizes" => [new ProductSizeRule()],
            "groups" => [new ProductGroupRule()],
        ]);



        \DB::beginTransaction();
        try {

            $pr = new Product();
            $pr->company_id = auth()->user()->company->id;
            $pr->category_id = $request->category;
            if ($request->menu) {
                $pr->menu_id = $request->menu;
                $pr->menu_type_id = $request->menu;
                // $pr->menu_type_id = Menu::find($request->menu)->menu_type_id;
            }

            $pr->price = $request->price;

            if($request->hasFile("image")){
                $product_photo = $request->image->store('/product-photo', 'public');
                // $photo = asset("/storage/".$product_photo);
                $pr->product_image = $product_photo;
            }

            $pr->name = $request->name;
            $pr->description = $request->description;
            $pr->option_type = $request->option_type;
            $pr->save();

            // $is_size = $request->option_type == 'size' ? true : false;

            if($request->option_type == 'size'){
                $sizes = json_decode($request->sizes);
                foreach ($sizes as $size) {

                    if(!$size->size) continue;

                    $product_size = ProductPrice::create([
                        'product_id' => $pr->id,
                        'size_id'    => $size->size,
                        'price'      => $size->price ?: 0,
                    ]);

                    foreach ($size->groups as $group) {

                        if(!$group->group || !$group->upto) continue;

                        $product_option_group = ProductOptionGroup::create([
                            'product_id'      => $pr->id,
                            "option_group_id" => $group->group,
                            "upto"            => $group->upto,
                            "size_id"         => $product_size->id,
                            "is_required"     => $group->is_required ? true : false,
                        ]);

                        foreach ($group->options as $option) {
                            if($option->is_checked && $option->id){
                                ProductOption::insertGetId([
                                    'product_id'              => $pr->id,
                                    "product_option_group_id" => $product_option_group->id,
                                    "option_id"               => $option->id,
                                ]);
                            }
                        }
                    }
                }
            }else if($request->option_type == 'group'){
                $groups = json_decode($request->groups);
                foreach ($groups as $group) {

                    if(!$group->group || !$group->upto) continue;

                    $product_option_group = ProductOptionGroup::create([
                        'product_id'      => $pr->id,
                        "option_group_id" => $group->group,
                        "upto"            => $group->upto,
                        "is_required"     => $group->is_required ? true : false,
                    ]);

                    foreach ($group->options as $option) {
                        if($option->is_checked && $option->id){
                            ProductOption::insertGetId([
                                'product_id'              => $pr->id,
                                "product_option_group_id" => $product_option_group->id,
                                "option_id"               => $option->id,
                            ]);
                        }
                    }
                }
            }

            \DB::commit();
            return response()->json([
                "success" => true,
                "message" => "Created Successfully"
            ], 200);
            // return redirect()->route('product.index')->with(['success' => 'Created successfully']);
        } catch (\Exception $exception) {
            \DB::rollback();
            return response()->json([
                "success" => false,
                "message" => $exception->getMessage()
            ], 422);
        }
    }


    public function show($id){
        $data['product']    =   Product::where('id',$id)->first();
        $data['sizes']      =   ProductPrice::where('product_id',$id)->get();
        $data['groups']     =   ProductOptionGroup::where('product_id',$id)->get();
        $data['options']    =   ProductOption::where('product_id',$id)->get();
        $data['optionslist']=   Option::all();
        return response([
            'data' => $data
        ]);
    }

    public function edit($id){

        $product = Product::find($id);

        $categories = Category::where('company_id',auth()->user()->company->id)->get();
        $menus = auth()->user()->company->menus;
        $menuTypes = auth()->user()->company->menuTypes;
        $sizes = auth()->user()->company->sizes;
        $options = Option::where('company_id', auth()->user()->company->id)->get();
        $optiongroups = OptionGroup::where('company_id',auth()->user()->company->id)->get();

        $product_sizes = ProductPrice::where('product_id', $id)->get();
        $product_groups = ProductOptionGroup::where('product_id', $id)->get();
        $product_options = ProductOption::where('product_id', $id)->get();

        return view('business-app.product.edit', compact('product', 'categories', 'menus', 'menuTypes', 'sizes', 'options', 'optiongroups', 'product_sizes', 'product_groups', 'product_options'));
    }


    public function update($product_id, Request $request){

        $request->validate([
            'name' => 'nullable|string',
            'category' => 'required',
            'menu' => 'required',
            'price' => 'required',
            "sizes" => [new ProductSizeRule()],
            "groups" => [new ProductGroupRule()],
        ]);

        \DB::beginTransaction();
        try {

            $pr = Product::find($product_id);
            $pr->category_id = $request->category;
            if ($request->menu) {
                $pr->menu_id = $request->menu;
                $pr->menu_type_id = $request->menu;
                // $pr->menu_type_id = Menu::find($request->menu)->menu_type_id;
            }

            $pr->price = $request->price;


            if($request->hasFile("image")){
                $product_photo = $request->image->store('/product-photo', 'public');
                // $photo = asset("/storage/".$product_photo);
                $pr->product_image = $product_photo;
            }

            $pr->name = $request->name;
            $pr->description = $request->description;
            $pr->option_type = $request->option_type;
            $pr->save();



            ProductOption::where('product_id',$product_id)->delete();
            ProductOptionGroup::where('product_id',$product_id)->delete();
            ProductPrice::where('product_id',$product_id)->delete();

            // $is_size = $request->option_type == 'size' ? true : false;

            if($request->option_type == 'size'){
                $sizes = json_decode($request->sizes);
                foreach ($sizes as $size) {
                    $product_size = ProductPrice::create([
                        'product_id' => $pr->id,
                        'size_id'    => $size->size,
                        'price'      => $size->price,
                    ]);

                    foreach ($size->groups as $group) {

                        $product_option_group = ProductOptionGroup::create([
                            'product_id'      => $pr->id,
                            "option_group_id" => $group->group,
                            "upto"            => $group->upto,
                            "size_id"         => $product_size->id,
                            "is_required"     => $group->is_required ? true : false,
                        ]);

                        foreach ($group->options as $option) {
                            if($option->is_checked){
                                ProductOption::insertGetId([
                                    'product_id'              => $pr->id,
                                    "product_option_group_id" => $product_option_group->id,
                                    "option_id"               => $option->id,
                                ]);
                            }
                        }
                    }
                }
            }else if($request->option_type == 'group'){
                $groups = json_decode($request->groups);
                foreach ($groups as $group) {
                    $product_option_group = ProductOptionGroup::create([
                        'product_id'      => $pr->id,
                        "option_group_id" => $group->group,
                        "upto"            => $group->upto,
                        "is_required"     => $group->is_required ? true : false,
                    ]);

                    foreach ($group->options as $option) {
                        if($option->is_checked){
                            ProductOption::insertGetId([
                                'product_id'              => $pr->id,
                                "product_option_group_id" => $product_option_group->id,
                                "option_id"               => $option->id,
                            ]);
                        }
                    }
                }
            }

            \DB::commit();
            return response()->json([
                "success" => true,
                "message" => "Updated Successfully"
            ], 200);

        } catch (\Exception $exception) {
            \DB::rollback();
            // dd($exception);
            return response()->json([
                "success" => false,
                "message" => $exception->getMessage()
            ], 422);
        }

    }



    public function destroy($product_id){
        Product::where('id', $product_id)->delete();
        ProductPrice::where('product_id', $product_id)->delete();
        ProductOptionGroup::where('product_id', $product_id)->delete();
        ProductOption::where('product_id', $product_id)->delete();
        return redirect()->route('product.index')->with(['success' => 'Deleted successfully']);
    }

}
