<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\PromoUse;
use App\Models\Transaction;
use App\Models\UserOrder;
use App\Models\UserPromo;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Cartalyst\Stripe\Stripe;
use Cartalyst\Stripe\Exception\NotFoundException;
use Cartalyst\Stripe\Exception\UnauthorizedException;
use Cartalyst\Stripe\Exception\CardErrorException;
use Illuminate\Support\Facades\DB;
use PDO;

class SalesController extends Controller
{
    public function index()
    {
        $orders = Order::where('company_id', auth()->user()->company->id)->paginate(10);

        $user = auth()->user();
        $company = $user->company;

        $payout_days = $company->payouts_days;

        $date  = Carbon::now()->subDays($payout_days)->format('Y-m-d');

        $available_balance = Transaction::where('company_id', $company->id)
            ->whereDate('created_at', '<=', $date)
            ->where('type', Transaction::FOOD_ORDER)
            ->where('is_payout', 0)->sum('amount');

        $pending_balance = Transaction::where('company_id', $company->id)
            ->whereDate('created_at', '>', $date)
            ->where('type', Transaction::FOOD_ORDER)
            ->where('is_payout', 0)->sum('amount');

        return view('business-app.sales.index', compact('orders', 'available_balance', 'pending_balance'));
    }




    public function saleDetails($trxId){
        error_reporting(0);
        $transaction = Transaction::with(['company', 'user'])->leftjoin("user_promo","user_promo.id","=","transactions.refund_promo_id")
                                    ->selectRaw("transactions.*,user_promo.status as user_promo_status")
                                    ->selectRaw("IFNULL((SELECT COUNT(id) FROM promo_use WHERE promo_use.user_promo_id > 0 AND promo_use.user_promo_id = user_promo.id ),0) as is_promo_used")

                                    ->where('transactions.id',$trxId)
                                    ->first();
        $order       = null;
        if($transaction && $transaction->user_order_id > 0){
            $user_order  = UserOrder::where('user_order.id',$transaction->user_order_id)->first();
            $order       = Order::with(['company', 'user','orderProducts'])->where('orders.id',$user_order->order_id)->first();
        }
        $previousDate       =   Carbon::parse(date('Y-m-d',strtotime($transaction->created_at)));
        $today              =   Carbon::today();
        $days               =   $today->diffInDays($previousDate);
        return view('business-app.sale-details',compact('transaction','order','days'));
    }
    public function refundSaleOrder(Request $request,$trxId){
        error_reporting(0);
        $transaction = Transaction::with(['company', 'user'])->leftjoin("user_promo","user_promo.id","=","transactions.refund_promo_id")
                                    ->selectRaw("transactions.*,user_promo.status as user_promo_status")
            ->selectRaw("IFNULL((SELECT COUNT(id) FROM promo_use WHERE promo_use.user_promo_id > 0 AND promo_use.user_promo_id = user_promo.id ),0) as is_promo_used")
                                    ->where('transactions.id',$trxId)
                                    ->first();
        $order       = null;
        if($transaction && $transaction->user_order_id > 0){
            $user_order  = UserOrder::where('user_order.id',$transaction->user_order_id)->first();
            $order       = Order::with(['company', 'user','orderProducts'])->where('orders.id',$user_order->order_id)->first();
        }
        if(($order && $order->status == 1) || ($transaction->refund_promo_id  > 0 && $transaction->user_promo_status == 'completed')){
            $previousDate   =   Carbon::parse(date('Y-m-d',strtotime($transaction->created_at)));
            $today          =   Carbon::today();
            $days           =   $today->diffInDays($previousDate);
            return view('business-app.refund-sale-order',compact('order','transaction','days'));
        }else{
            $request->session()->flash('success', 'Only paid/completed records are allowed to refund.');
            return redirect(route('sales'));
        }
    }
    public function getSalesData(Request $request)
    {
//dd($request->all());
        $query = UserOrder::query();
        if($request->has('is_refund_requested') && $request->input('is_refund_requested') == 1){
            $query->join("orders",function ($join) use ($request){
                $join->on("orders.id","=","user_order.order_id");
                $join->Where("orders.is_refund_requested",1);
            });
        }
        $query->join("transactions","transactions.user_order_id","=","user_order.id");
        $query->selectRaw("user_order.*, COUNT(DISTINCT transactions.id) as trx_count, user_order.id,users.name as user_name,users.phone_number as user_phone,DATE_FORMAT(user_order.created_at, '%Y-%m-%d') as created");
        $query->selectRaw("IF(user_order.status  = 0, 'New ',IF(user_order.status  = 1, 'Paid ',IF(user_order.status  = 2, 'Assigned ',IF(user_order.status  = 3,'Cancelled','Refunded'))))  as status");
        $query->selectRaw("transactions.type as transaction_type,transactions.refund_promo_id,transactions.id as transaction_id,user_promo.status as user_promo_status");
        $query->selectRaw("IFNULL(user_order.subtotal,transactions.amount) as subtotal");
        $query->selectRaw("IFNULL((SELECT COUNT(id) FROM promo_use WHERE promo_use.user_promo_id > 0 AND promo_use.user_promo_id = user_promo.id ),0) as is_promo_used");
        $query->leftjoin("user_promo","user_promo.id","=","transactions.refund_promo_id");
        $query->where("user_order.company_id",auth()->user()->company->id);
        $search = false;
        if ($request->has('order_id') && !empty(trim($request->input('order_id')))) {
            $query->where("user_order.id",$request->input('order_id'));
        }
        elseif ( ($request->has('user_name') && !empty(trim($request->input('user_name'))))  || ($request->has('user_phone') && !empty(trim($request->input('user_phone')))) ) {
            $query->join("users",function ($join) use ($request){
                $join->on("users.id","=","user_order.user_id");
                if(($request->has('user_name') && !empty(trim($request->input('user_name'))))){
                    $join->Where("users.name", 'like',"%{$request->input('user_name')}%");
                }
                if(($request->has('user_phone') && !empty(trim($request->input('user_phone'))))){
                    $join->Where("users.phone_number", 'like',"%{$request->input('user_phone')}%");
                }
            });
            $search = true;
        }
        if($search == false){
            $query->leftjoin("users","users.id","=","user_order.user_id");
        }
        if($request->has('order')){
           $columns =  $request->columns;
           foreach ($request->input('order') as $ordr){
               $query->orderBy($columns[$ordr['column']]['name'],$ordr['dir']);
           }
        }

        if ($request->has('trx_type') && !empty(trim($request->input('trx_type')))) {
            $query->whereRaw(" transactions.type = '{$request->input('trx_type')}' ") ;
        }

        $query->whereNotNull('user_order.id');
        $query->groupBy('user_order.id');
        //$query->withTrashed();
        $data           = $query->get();


        $result         = $data;


        $query = Transaction::query();
        $query->leftjoin("user_order","user_order.id","=","transactions.user_order_id");
        $query->selectRaw("user_order.*, 1 as trx_count,user_order.id,users.name as user_name,users.phone_number as user_phone,DATE_FORMAT(transactions.created_at, '%Y-%m-%d') as created");
        $query->selectRaw("IF(user_order.status  = 0, 'New ',IF(user_order.status  = 1, 'Paid ',IF(user_order.status  = 2, 'Assigned ',IF(user_order.status  = 3,'Cancelled','Refunded'))))  as status");
        $query->selectRaw("transactions.type as transaction_type,transactions.refund_promo_id,transactions.id as transaction_id,user_promo.status as user_promo_status");
        $query->selectRaw("IFNULL(user_order.subtotal,transactions.amount) as subtotal");
        $query->selectRaw("IFNULL((SELECT COUNT(id) FROM promo_use WHERE promo_use.user_promo_id > 0 AND promo_use.user_promo_id = user_promo.id ),0) as is_promo_used");
        $query->leftjoin("user_promo","user_promo.id","=","transactions.refund_promo_id");
        $query->where("transactions.company_id",auth()->user()->company->id);
        $search = false;
        if ($request->has('order_id') && !empty(trim($request->input('order_id')))) {
            $query->where("user_order.id",$request->input('order_id'));
        }
        elseif ( ($request->has('user_name') && !empty(trim($request->input('user_name'))))  || ($request->has('user_phone') && !empty(trim($request->input('user_phone')))) ) {
            $query->join("users",function ($join) use ($request){
                $join->on("users.id","=","user_order.user_id");
                if(($request->has('user_name') && !empty(trim($request->input('user_name'))))){
                    $join->Where("users.name", 'like',"%{$request->input('user_name')}%");
                }
                if(($request->has('user_phone') && !empty(trim($request->input('user_phone'))))){
                    $join->Where("users.phone_number", 'like',"%{$request->input('user_phone')}%");
                }
            });
            $search = true;
        }
        if($search == false){
            $query->leftjoin("users","users.id","=","transactions.user_id");
        }
        if($request->has('order')){
            $columns =  $request->columns;
            foreach ($request->input('order') as $ordr){
                $query->orderBy($columns[$ordr['column']]['name'],$ordr['dir']);
            }
        }

        if ($request->has('trx_type') && !empty(trim($request->input('trx_type')))) {
            $query->whereRaw(" transactions.type = '{$request->input('trx_type')}' ") ;
        }

        $query->whereNull('transactions.user_order_id');
        if( @$request->input('is_refund_requested') != 1) {
            //$query->withTrashed();
            $data2 = $query->get();
            foreach ($data2 as $dt) {
                $result->push($dt);
            }
        }







//        $data           = $query->skip($request->start)->take($request->length)->get();
        $recordsTotal   =    (int)collect($result)->count();//Order::where("user_order.company_id",auth()->user()->company->id)->count();
        return response()->json([
            'draw' => (int)$request->draw, 
            'start' => (int)$request->start, 
            'length' => (int)$request->length, 
            'recordsTotal' => (int)$recordsTotal,
            'recordsFiltered' => (int)collect($result)->count(),
            'data' => $result,
            'order' => @$request->order,
            'columns' => @$request->columns,
        ]);
    }




    public function makeRefund(Request $request,$trxId){
        $stripe = Stripe::make(config('stripe.secret'));


        try {
            $transaction    =   Transaction::leftjoin("user_promo","user_promo.id","=","transactions.refund_promo_id")
                                                ->selectRaw("transactions.*,user_promo.status as user_promo_status")
                                                ->selectRaw("IFNULL((SELECT COUNT(id) FROM promo_use WHERE promo_use.user_promo_id > 0 AND promo_use.user_promo_id = user_promo.id ),0) as is_promo_used")
                                                ->where('transactions.id',$trxId)
                                                ->whereNotNull('payment_intent_id')
                                                ->first();
            $previousDate   =   Carbon::parse(date('Y-m-d',strtotime(@$transaction->created_at)));
            $today          =   Carbon::today();
            $days           =   $today->diffInDays($previousDate);
            $order          =   null;
            if($transaction && $transaction->user_order_id > 0){
                $user_order  = UserOrder::where('user_order.id',$transaction->user_order_id)->first();
                $order       = Order::with(['company', 'user','orderProducts'])->where('orders.id',$user_order->order_id)->first();
            }
//            $transaction->payment_intent_id = 'pi_3Mxsw5FtP1fqU7hm0A3l3xPn';
            if(($order && $order->status == 1) || ($transaction->refund_promo_id  > 0 && $transaction->user_promo_status == 'completed' AND $transaction->is_promo_used == 0)){
                $paymentIntent  =   $stripe->paymentIntents()->find($transaction->payment_intent_id);
                $charge_id      =   $paymentIntent['latest_charge'];
                $charge_amount  =   $paymentIntent['amount_received']/100;
                //dd($transaction,$paymentIntent);

                if($request->type == 'full'){
                    //Full Refund
                    $refund = $stripe->refunds()->create($charge_id);
                }else{
                    //Partial Refund
                    $amount =   $request->amount;
                    $amount =   $amount <= $charge_amount ? $amount : $charge_amount;
                    $refund =   $stripe->refunds()->create($amount);
                }
                if($refund){
                    Transaction::where('id',$transaction->id)->update([
                        'refund_id'         => $refund['id'],
                        'refund_reason'     => $request->refund_reason
                    ]);
                    if($order && $order->status == 1){
                        $order->update([
                            'status'        => Order::STATUS_REFUND,
                            'refund_amount' => (float)$order->refund_amount+($refund['amount']/100)
                        ]);
                        $user_order->update([
                            'status'        => Order::STATUS_REFUND
                        ]);
                    }else{
                        $userPromo = UserPromo::where('id',$transaction->refund_promo_id)->first();
                        if($userPromo){
                            $userPromo->status = UserPromo::STATUS_NEW;
                            $userPromo->save();
//                            $otherUserPromo = UserPromo::where('id', $userPromo->parent_promo_id)->first();
//                            if ($otherUserPromo) {
//                                //$otherUserPromo->status = UserPromo::STATUS_PROCESSING;
//                                $otherUserPromo->save();
//                            }
                        }
                    }
                    $request->session()->flash('success', 'Refund successfull.');
                    return redirect(route('sales'));
                }
            }else{
                $request->session()->flash('error', "Invalid refund request.");
            }
        } catch (NotFoundException $e) {
            $request->session()->flash('error', "The charge ID was not found.");
        } catch (UnauthorizedException $e) {
            $request->session()->flash('error', "Unauthorized access to the Stripe API");
        } catch (CardErrorException $e) {
            $request->session()->flash('error', "Card error occurred during refund");
        } catch (\Exception $e) {
            $request->session()->flash('error', $e->getMessage());
        }
        return redirect()->back();

        //test
    }
    public function our_backup_database(){

        $DbName = DB::connection()->getDatabaseName();
        $get_all_table_query = "SHOW TABLES ";
        $result = DB::select(DB::raw($get_all_table_query));

        $prep = "Tables_in_$DbName";
        foreach ($result as $res){
            $tables[] =  $res->$prep;
        }



        $connect = DB::connection()->getPdo();

        $get_all_table_query = "SHOW TABLES";
        $statement = $connect->prepare($get_all_table_query);
        $statement->execute();
        $result = $statement->fetchAll();


        $output = '';
        foreach($tables as $table)
        {
            $show_table_query = "SHOW CREATE TABLE " . $table . "";
            $statement = $connect->prepare($show_table_query);
            $statement->execute();
            $show_table_result = $statement->fetchAll();

            foreach($show_table_result as $show_table_row)
            {
                $output .= "\n\n" . $show_table_row["Create Table"] . ";\n\n";
            }
            $select_query = "SELECT * FROM " . $table . "";
            $statement = $connect->prepare($select_query);
            $statement->execute();
            $total_row = $statement->rowCount();

            for($count=0; $count<$total_row; $count++)
            {
                $single_result = $statement->fetch(\PDO::FETCH_ASSOC);
                $table_column_array = array_keys($single_result);
                $table_value_array = array_values($single_result);
                $output .= "\nINSERT INTO $table (";
                $output .= "" . implode(", ", $table_column_array) . ") VALUES (";
                $output .= "'" . implode("','", $table_value_array) . "');\n";
            }
        }
        $file_name = 'database_backup_on_' . date('y-m-d') . '.sql';
        $file_handle = fopen($file_name, 'w+');
        fwrite($file_handle, $output);
        fclose($file_handle);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . basename($file_name));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file_name));
        ob_clean();
        flush();
        readfile($file_name);
        unlink($file_name);


    }
}
