<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Size;
use Illuminate\Http\Request;

class SizeController extends Controller
{
    public function index()
    {
        $sizes = Size::where('company_id', auth()->user()->company->id)->paginate(20);
        return view('business-app.size.index', compact('sizes'));
    }

    public function create(){
        return view('business-app.size.create');
    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
            'price' => 'required'
        ]);

        Size::create([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
            'price' => $request->price
        ]);

        return redirect()->route('size.index')->with("success", "Size Created Successfully!");

    }

    public function edit($id)
    {
        $size = Size::where('id', $id)->where('company_id', auth()->user()->company->id)->first();
        return view('business-app.size.edit', compact('size'));
    }

    public function update($id, Request $request){

        $request->validate([
            'name' => 'required',
            'price' => 'required',
        ]);

        $size = Size::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $size->update([
            'name' => $request->name,
            'price' => $request->price,
        ]);

        return redirect()->route('size.index')->with("success", "Size Updated Successfully!");
    }

    public function destroy($id){

        $size = Size::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $size->delete();

        return redirect()->route('size.index')->with("success", "Size Deleted Successfully!");

    }
}
