<?php

namespace App\Http\Controllers\BusinessApp;

use Illuminate\Http\Request;
use Stripe\Exception\ApiErrorException;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


class StripePayoutRefreshController extends Controller
{
    public function refresh()
    {
        $user = Auth::user();
        $stripeConnectId = $user->stripe_connect_id;
        $stripeSecretKey =config('stripe.secret');

        $stripe = new \Stripe\StripeClient(
            $stripeSecretKey
        );
        // Set the parameters for the account link
        $accountLinkParams = [
            'account' => $stripeConnectId,
            'refresh_url' => url('/business-app/dashboard/stripe_payout_refresh'),
            'return_url' => url('/business-app/dashboard/stripe_payout_return'),
            'type' => 'custom_account_verification',
            'collect' => 'eventually_due',
        ];

        try {
            // Create a new account link
            $accountLink = $stripe->accountLinks->create($accountLinkParams);

            // Redirect the user to the account link URL
            return redirect($accountLink->url);
        } catch (ApiErrorException $e) {
            // Handle errors here
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
