<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Tip;
use Illuminate\Http\Request;

class TipController extends Controller
{
    public function index()
    {
        $tips = Tip::where('company_id', auth()->user()->company->id)->get();
        return view('business-app.tip.index', compact('tips'));
    }

    public function create(){
        return view('business-app.tip.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'tip' => 'required',
        ]);

        Tip::create([
            'company_id' => auth()->user()->company->id,
            'tip' => $request->tip,
        ]);

        return redirect()->route('tip.index')->with("success", "Tip Created Successfully!");
    }

    public function update($tip_id, Request $request){

        $tips = $request->tip;

        foreach ($tips as $tip_id => $tip_value) {
            $t = Tip::find($tip_id);
            $t->tip = $tip_value;
            $t->save();
        }

        return redirect()->route('tip.index')->with("success", "Tip Updated Successfully!");
    }

}
