<?php

namespace App\Http\Resources;

use App\Models\CustomerReservations;
use App\Models\Discount;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $discount = Discount::where('company_id', $this->id)->first();
        $countdownTime = null;
        $startsAt = null;
        $endsAt = null;

        if($discount){

            $startsAt = strtotime($discount->pt_starts_at);
            $endsAt = strtotime("+$discount->pt_total_hours hours", $startsAt);
    
            if($discount->pt_type == "prize_hour"){
                
                $dayNumber = date('N', strtotime('now'));
                $disHour = $discount->discount_hours()->where("day", $dayNumber)->first();
                
                $endsAt = $disHour?->ends_at ?  strtotime(strftime("%F") . ' ' .$disHour->ends_at) : null;
                // if current day discount time ends then look for next day
                if(!$disHour || ($endsAt && time() > $endsAt) ){
                    $disHour = $discount->discount_hours()->where("day", ">" ,$dayNumber)->orderBy('day', 'asc')->first();
                    if(!$disHour){
                        $disHour = $discount->discount_hours()->orderBy('day', 'asc')->first();
                    }
                }
                
                $dayDiff = $dayNumber > $disHour->day ? (7 - $dayNumber) + $disHour->day : $disHour->day - $dayNumber;
                $startsAt = strtotime(strftime("%F") . ' ' .$disHour->starts_at." + $dayDiff days");
                $endsAt = strtotime(strftime("%F") . ' ' .$disHour->ends_at." + $dayDiff days");
               
            }

            if(time() >= $startsAt && time() <= $endsAt){
                $countdownTime = $endsAt - time();
            }
    
            $claim_repo = new DiscountClaimRepository();
            $user = \Auth::user();
            $remainingDiscount = 0;
            if($user){
                $remainingDiscount = $claim_repo->remaingDiscountAmount($user, $discount, $discount->company_id);
            }
    
    
            $percentage = 0;
            $percentage_off = $discount->terms;
    
            if($percentage_off >= 10 && $percentage_off <= 25){
                $percentage = 95;
            }else if($percentage_off > 25 && $percentage_off <= 30){
                $percentage = 90;
            }else if($percentage_off > 30 && $percentage_off <= 50){
                $percentage = 85;
            }else if($percentage_off > 50 && $percentage_off <= 90){
                $percentage = 80;
            }
        }

        $reservations = CustomerReservations::where('company_id', $this->id)->count();
        return [
            "id" => $this->id,
            "name" => $this->name,
            "address_line_1" => $this->address_line_1,
            "address_line_2" => $this->address_line_2,
            "city" => $this->city,
            "rating" => $this->rating ?? 0,
            "cover_photo" => $this->cover_photo,
            "banner_photo" => $this->banner_photo,
            "phone_number" => $this->phone_number,

            "prime_percentage_off" => $discount?->pt_percentage ?? 0,
            "regular_percentage_off" => $discount?->terms ?? 0,
            "prime_time_type" => $discount?->pt_type,
            "prime_starts_at" => $discount ? date("m.d h:iA", strtotime($discount->pt_starts_at)) : null,
            "prime_total_hours" => $discount?->pt_total_hours,
            "prize_time_starts_at" => date("D h:iA", $startsAt),
            "prize_time_ends_at" => date("h:iA", $endsAt),
            "countdown_time" => $countdownTime,

            "reservations" => $reservations,
            "slug" => $this->slug
        ];
    }
}
