<?php

namespace App\Http\Resources;

use App\Models\Company;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomerDiscountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        
        $countdownTime = null;

        $startsAt = strtotime($this->pt_starts_at);
        $endsAt = strtotime("+$this->pt_total_hours hours", $startsAt);

        if($this->pt_type == "prize_hour"){
            
            $dayNumber = date('N', strtotime('now'));
            $disHour = $this->discount_hours()->where("day", $dayNumber)->first();
            
            $endsAt = $disHour?->ends_at ?  strtotime(strftime("%F") . ' ' .$disHour->ends_at) : null;
            // if current day discount time ends then look for next day
            if(!$disHour || ($endsAt && time() > $endsAt) ){
                $disHour = $this->discount_hours()->where("day", ">" ,$dayNumber)->orderBy('day', 'asc')->first();
                if(!$disHour){
                    $disHour = $this->discount_hours()->orderBy('day', 'asc')->first();
                }
            }
            
            $dayDiff = $dayNumber > $disHour->day ? (7 - $dayNumber) + $disHour->day : $disHour->day - $dayNumber;
            $startsAt = strtotime(strftime("%F") . ' ' .$disHour->starts_at." + $dayDiff days");
            $endsAt = strtotime(strftime("%F") . ' ' .$disHour->ends_at." + $dayDiff days");
           
        }

        if(time() >= $startsAt && time() <= $endsAt){
            $countdownTime = $endsAt - time();
        }

        $claim_repo = new DiscountClaimRepository();
        $user = \Auth::user();
        $remainingDiscount = 0;
        if($user){
            $remainingDiscount = $claim_repo->remaingDiscountAmount($user, $this, $this->company_id);
        }


        $percentage = 0;
        $percentage_off = $this->terms;

        if($percentage_off >= 10 && $percentage_off <= 25){
            $percentage = 95;
        }else if($percentage_off > 25 && $percentage_off <= 30){
            $percentage = 90;
        }else if($percentage_off > 30 && $percentage_off <= 50){
            $percentage = 85;
        }else if($percentage_off > 50 && $percentage_off <= 90){
            $percentage = 80;
        }

        return [
            "id" => $this->id,
            "name" => $this->name,
            "starts_at" => $this->starts_at?->format("Y-m-d\TH:i:s"),
            "ends_at" => $this->ends_at?->format("Y-m-d\TH:i:s"),
            "credit_amount" => $this->amount,
            "limit_claims" => $this->max_users,
            "maximum_discount" => $this->max_discount_per_order,
            "total_number_of_discount" => $this->total_no_of_discounts,
            "percentage_off" => $this->terms,

            "prime_time_type" => $this->pt_type,
            "prime_starts_at" => date("m.d h:iA", strtotime($this->pt_starts_at)),
            "prime_total_hours" => $this->pt_total_hours,
            "prime_percentage_off" => $this->pt_percentage,
            "pay_amount" => $this->pt_paying_amount,
            "prize_time_starts_at" => date("D h:iA", $startsAt),
            "prize_time_ends_at" => date("h:iA", $endsAt),
            "countdown_time" => $countdownTime,
            "remaining_discount" => number_format((float)$remainingDiscount, 2, '.', ''),
            "upto_off" => $percentage
        ];
    }
}
