<?php

namespace App\Http\Resources;

use App\Models\CustomerStripeInfo;
use Illuminate\Http\Resources\Json\JsonResource;

class EgiftResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $customerStripe = CustomerStripeInfo::find($this->customer_stripe_info_id);
        
        return [
            "id" => $this->id,
            'user_id' => $this->user_id,
            'for_me' => (bool) $this->user_id == auth()->user()->id,
            'customer_stripe_info_id' => $this->customer_stripe_info_id,
            'sender_id' => $this->sender_id,
            'total_credit' => $this->total_credit,
            'gift_amount' => $this->gift_amount,
            'extra_saving' => $this->extra_saving,
            'activation_fee' => $this->activation_fee,
            'total_pay' => $this->total_pay,
            "last_four_digits" => $customerStripe->card_last_4_digits,
            "full_name" => $this->user?->name,
            "phone_number" => $this->user?->phone_number,
            "email" => $this->user?->email,
            "is_confirmed" => $this->is_confirmed
        ];
    }
}
