<?php

namespace App\Http\Resources;

use App\Models\Egift;
use App\Models\Tax;
use App\Models\Tip;
use App\Models\UsedEgift;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $user = $this->user;
        $orderedItems = $this->orderItems;
        // $optionTotal = 0;

        // foreach ($orderedItems as $orderedItem) {
        //     $optionTotal += $orderedItem->quantity * $orderedItem->price;

        //     $orderOptions = json_decode($orderedItem->product_options);
        //     foreach ($orderOptions as $copt){
        //         foreach ($copt->options as $op){
        //             $optionTotal += $op->price ?? 0;
        //         }
        //     }

        // }

        // $subtotal = $this->subtotal + $optionTotal;
        $subtotal = $this->subtotal;

        $tip = 0;
        if($request->tip_id){
            $tipObj = Tip::where('company_id', $this->company_id)->where('id', $request->tip_id)->first();
            $tip = ($subtotal * ($tipObj?->tip / 100));
        }


        // $taxObj = Tax::where('company_id', $this->company_id)->first();
        // $tax = ($subtotal * ($taxObj?->tax / 100));

        $total = $this->total + $tip;


        $claim_repo = new DiscountClaimRepository();
        $discount = $user ? $claim_repo->discountAmount($user, $subtotal, $this->company_id) : 0;

        $global_credit_balance = $user ? $claim_repo->remainginGlobalCredit($user->id) : 0;

        $apply_global_credit = $this->used_global_credit;

        if($global_credit_balance > 0){
            if($global_credit_balance >= $discount){
                $apply_global_credit = $discount;
            }else{
                $apply_global_credit = $global_credit_balance;
            }
        }

        $remaining_payment = $total - $apply_global_credit;
        $apply_egift = $this->used_egift;
        if($remaining_payment > 0){

            $egift_amount = Egift::where('user_id', $user->id)->sum("gift_amount");
            $used_egift = UsedEgift::where('user_id', $user->id)->sum("used_amount");
            $egift_balance = $egift_amount - $used_egift;

            if($egift_balance > 0){

                if($egift_balance >= $remaining_payment){
                    $apply_egift = $remaining_payment;
                }else{
                    $apply_egift = $egift_balance;
                }
            }
        }

        $remaining_payment = $remaining_payment - $apply_egift;

        return [
            "id" => $this->id,
            "full_discount" => $discount > 0 ? number_format((float)$discount, 2, '.', '') : null,
            "discount" => number_format((float)$this->discount, 2, '.', ''),
            "tax" => number_format((float)$this->tax, 2, '.', ''),
            "tip" => number_format((float)$tip, 2, '.', ''),
            "subtotal" => number_format((float)$this->subtotal, 2, '.', ''),
            "used_egift" => number_format((float)$apply_egift, 2, '.', ''),
            "used_global_credit" => number_format((float)$apply_global_credit, 2, '.', ''),
            "due_amount" => number_format((float)$remaining_payment, 2, '.', ''),
            "total" =>  number_format((float)$total, 2, '.', ''),
            "status" => $this->status,
            "customer_name" => $this->user?->name,
            "customer_phone" => $this->user?->phone_number,
            "company_id" => $this->company?->id,
            "company_name" => $this->company?->name,
            "company_address" => $this->company?->address_line_1,
            "company_banner" => $this->company?->banner_photo,
            "created_at" => $this->created_at->format("d/m/Y"),
            "items" => OrderItemResource::collection($orderedItems),
        ];
    }
}
