<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\Product;

class ProductOptionGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "name" => $this->name,
            'price' => $this->price,
            'upto' => $this->pivot->upto,
            'is_required' => (bool) $this->pivot->is_required == 1 ? true : false,
            'options' => ProductOptionResource::collection($this->options),
        ];

    }
}
