<?php

namespace App\Http\Resources;

use App\Models\ProductOptionGroup;
use App\Models\ProductPrice;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\Product;
use App\Helpers\Helper;
use App\Models\Cart;
use App\Models\ProductOption;
use App\Models\Option;
use App\Models\OptionGroup;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $temp_user_id = $request->temp_user_id;

        // $prices = $this->prices ? json_decode($this->prices) : null;
        // $options = $this->options ? json_decode($this->options) : null;

        // $price = $this->prices['price'];
        // $product_name = $this->options['name'];
        // $description = $this->options['description'];
        // $image = $this->options['product_image'];
        $price = $this->price;
        $product_name = $this->name;
        $description = $this->description;
        $image = $this->product_image;

        // sizes - product prices
        // options_groups - product prices
        // options -
        
        // simple product
        // simple product with size. eg. small pizza: 20, large pizza: 30

        // product with option groups like combo package or Bowl.
        // Bowl has also sizes like Large or small
        // option group has options

        // each options has unique price
        // for example pepsi 10 then saus - 5
        // $has_variation = false;
        // $size = ProductPrice::where('product_id', $this->id)->where('price', '>', 0)->first();
        // if($size){
        //     $has_variation = true;
        // }

        // $product_option_groups = ProductOptionGroup::where('product_id', $this->id)->where('option_group_id', '!=', null)->first();
        // if($product_option_groups){
        //     $has_variation = true;
        // }

        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "category_id" => $this->category_id,
            "menu_id" => $this->menu_id,
            "menu_type_id" => $this->menu_type_id,
            "prices" => $price,
            "price" => "$".$price,
            "product_name" => $product_name,
            "description" => $description,
            "has_image" => $image ? true : false,
            "image" => $image ? asset("/storage/".$image) : null,
            // 'has_variation' => $has_variation,
            'custom_size' => count($this->customSize) ? sizeResource::collection($this->customSize,$this->customGroup) : [],
            'custom_group' => !count($this->customSize) ? groupResource::collection($this->customGroup) : [],
            "in_cart" => (int) Cart::where('temp_user_id', $temp_user_id)->where('product_id', $this->id)->count(),
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
        ];
    }
}


class sizeResource extends JsonResource
{
    private $sample;

    public function __construct($resource, $sample)
    {
        parent::__construct($resource);
        $this->sample = $sample;
    }

    public function toArray($request)
    {
        $product = Product::where('id', $this->pivot->product_id)
            ->first();

        $productGroups = ProductOptionGroup::where('product_id', $this->pivot->product_id)
            ->where("size_id", $this->pivot->id)
            ->pluck("option_group_id")->toArray();
    
        // $groups = OptionGroup::whereIn("id", $productGroups)->get();
        $groups = $product->customGroup()->whereIn("option_groups.id", $productGroups)->get();

        return [
            "id" => $this->id,
            // "company_id" => $this->company_id,
            "name" => $this->name,
            'price' => $this->price,
            // 'pivot' => $this->pivot,
            'custom_group' => groupResource::collection($groups),
        ];
    }
}

class groupResource extends JsonResource
{
    public function toArray($request)
    {
 
        $productOptions = ProductOption::where('product_id', $this->pivot->product_id)
                    ->pluck("option_id")->toArray();
        $options = Option::whereIn("id", $productOptions)->where("option_group_id", $this->pivot->option_group_id)->get();
        
        return [
            "id" => $this->id,
            // "company_id" => $this->company_id,
            "name" => $this->name,
            // 'pivot' => $this->pivot,
            'upto' => $this->pivot->upto,
            'is_required' => (bool) $this->pivot->is_required == 1 ? true : false,
            'options' => OptionResource::collection($options),
        ];
    }
}

class OptionResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            // "company_id" => $this->company_id,
            // "option_group_id" => $this->option_group_id,
            "name" => $this->name,
            "price" => $this->price,
        ];
    }
}
