<?php

namespace App\Http\Resources;

use App\Models\CustomerStripeInfo;
use App\Models\Egift;
use App\Models\UsedEgift;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        $customer_stripe_info = CustomerStripeInfo::where('customer_id', $this->id)->first();
        $claim_repo = new DiscountClaimRepository();
        $global_credit_amount = $claim_repo->remainginGlobalCredit($this->id);

        $egift_amount = Egift::where('user_id', $this->id)->sum("gift_amount");
        $used_egift = UsedEgift::where('user_id', $this->id)->sum("used_amount");
        $egift_balance = $egift_amount - $used_egift;

        return [
            "id"                        =>  $this->id,
            "user_id"                   =>  $this->id,
            'role'                      =>  $this->type,
            'is_admin'                  =>  $this->is_admin,
            "full_name"                 =>  $this->name,
            "email"                     =>  $this->email,
            "phone_number"              =>  $this->phone_number,
            "address"                   =>  $this->address,
            "user_qrcode"               =>  $this->user_qrcode,
            "profile_photo_url"         =>  $this->profile_photo_url,
            "date_of_birth"             =>  $this->date_of_birth ? date("Y-m-d",strtotime($this->date_of_birth)):null ,
            "photo_id"                  =>  $this->photo_id ? $this->photo_id :null,
            "medical_photo"             =>  $this->photo ? $this->photo:null,
            "medical_card_no"           =>  $this->medical_card_no,
            "medical_card_expiration"   =>  $this->medical_card_expiration ? date("Y-m-d",strtotime($this->medical_card_expiration)):null ,
            "meddical_card_state"       =>  $this->meddical_card_state,
            "caregiver_id_number"       =>  $this->caregiver_id_number,
            "last_four_digits" => $customer_stripe_info?->card_last_4_digits,
            "global_credit_amount" => number_format((float)$global_credit_amount ?? 0, 2, '.', ''),
            "egift_balance" => number_format((float)$egift_balance ?? 0, 2, '.', ''),
        ];
    }
}
