<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Area extends Model
{
    use SoftDeletes;
    use HasFactory;

    const TYPE_FOH = 'foh';
    const TYPE_BOH = 'boh';

    protected $fillable = [
        'name',
        'company_id',
        'type'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function employees()
    {
        return $this->belongsToMany(Employee::class, EmployeeArea::class,);
    }

    public function employeeAreas()
    {
        return $this->hasMany(EmployeeArea::class);
    }

    public function tables()
    {
        return $this->hasMany(Table::class);
    }

    public function scopeFoh($query){
        return $query->where('type', self::TYPE_FOH);
    }

}
