<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Cart extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'toppings' => 'array'
    ];

    public function setProductAttribute($value)
    {
        $properties = [];

        foreach ($value as $array_item) {
            if (!is_null($array_item['key'])) {
                $properties[] = $array_item;
            }
        }

        $this->attributes['toppings'] = json_encode($properties);
    }

    public function details()
    {
        return $this->belongsTo(CartDetails::class,'user_id','user_id');
    }
    public function options()
    {
        return $this->belongsTo(CartProductOptions::class,'cart_id','id');
    }

    public function product(){
        return $this->belongsTo(Product::class);
    }
}
