<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $guarded = [];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function menus()
    {
        return $this->belongsTo(Menu::class, 'menu_id')
            ->select('id', 'menu_type_id', 'company_id', 'day', 'from', 'to')
            ->with(['menuType']);
    }

    public function scopeRoot($query)
    {
        $query->whereNull('category_id');
    }

    public function subCategory()
    {
        return $this->hasMany(Category::class, 'category_id')->where('deleted_at', null);
    }

    public function products(){
        return $this->hasMany(Product::class);
    }
}
