<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Claim extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "claims";
    protected $casts = [
        'actual_balance' => 'float',
        'hypothetical_balance' => 'float',
        'amount_claim' => 'float',
        'user_claim_allowed' => 'integer',
        'claim_setting_enable' => 'integer',
        'expire_days' => 'integer',
        'expire' => 'datetime'
    ];
    protected $guarded = [];

    protected $fillable = [
        'actual_balance',
        'hypothetical_balance',
        'amount_claim',
        'user_claim_allowed',
        'claim_setting_enable',
        'claim_per_day',
        'expire_days',
        'first_user',
        'expire',
        'user_id',
        'company_id'
];

public function company()
{
    return $this->hasOne(Company::class, 'owner_id', 'id');
}
}
