<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyMenuType extends Model
{
    use HasFactory;

    public function companies()
    {
        return $this->hasMany(Company::class, 'id', 'menu_type_id');
    }

    public function menus()
    {
        return $this->hasMany(Menu::class, 'id', 'menu_type_id');
    }

    public function company_types(){
        return $this->hasMany(CompanyType::class, 'menu_type_id');
    }
}