<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Spatie\MediaLibrary\HasMedia;

class CompanyType extends Model 
{
    use HasFactory;

    protected $guarded = [];

    public function companies()
    {
        return $this->hasMany(Company::class, 'id', 'type_id');
    }
    public function activecompanies()
    {
        return $this->hasMany(Company::class, 'id', 'type_id')->where('business_active', 1);
    }

    public function menuType()
    {
        return $this->belongsTo(CompanyMenuType::class, 'menu_type_id')
            ->select('id', 'name')
            ->with('menus');
    }

    public function registerMediaConversions(Media $media = null): void
    {
        $this->addMediaConversion('thumb')
            ->width(130)
            ->height(130);
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('main')->singleFile();
        $this->addMediaCollection('my_multi_collection');
    }

    
}
