<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerReservations extends Model
{
    use HasFactory;

    const STATUS_NEW = 0;
    const STATUS_ASSIGNED = 1;
    const STATUS_CANCELLED = 2;
    const STATUS_COMPLETED = 3;


    protected $table    = 'customer_reservations';
    protected $fillable = [
                            'status',
                            'customer_id',
                            'company_id',
                            'order_id',
                            'table_id',
                            'party_size',
                            'datetime',
                            'notes'
                           ];

    protected $casts = [
        'datetime' => 'datetime:Y-m-d H:i',
        'created_at' => 'datetime:Y-m-d',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class,'customer_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function table()
    {
        return $this->belongsTo(Table::class, 'table_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class,'customer_id');
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
